/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.jslib;

import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.jslib.BdfJsLibBuilder;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.text.ParseException;
import java.util.Map;
import java.util.SortedMap;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.jslib.TemplateFamily;
import net.mapeadores.util.jslib.TemplateFamilyBuilder;
import net.mapeadores.util.text.RelativePath;

public final class AppJsLibFactory {
    private final ResourceStorages resourceStorages;
    private final AppConf appConf;
    private final BdfJsLibBuilder jsLibBuilder = new BdfJsLibBuilder();
    private final RelativePath appDir;

    private AppJsLibFactory(ResourceStorages resourceStorages, AppConf appConf) {
        this.resourceStorages = resourceStorages;
        this.appConf = appConf;
        this.appDir = StorageUtils.buildAppResourcePath(appConf.getAppName(), "");
    }

    public static JsLib newInstance(ResourceStorages resourceStorages, AppConf appConf) {
        AppJsLibFactory factory = new AppJsLibFactory(resourceStorages, appConf);
        factory.run();
        return factory.toJsLib();
    }

    private void run() {
        for (String js : this.appConf.getArray("core_jsorder")) {
            try {
                RelativePath jsPath = this.appDir.parseChild("js/" + js);
                this.jsLibBuilder.addJsScript(jsPath);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        SortedMap<String, RelativePath> subFolders = this.resourceStorages.listSubFolders(this.appDir);
        for (Map.Entry<String, RelativePath> entry : subFolders.entrySet()) {
            RelativePath subfolderPath = entry.getValue();
            switch (entry.getKey()) {
                case "templates": {
                    TemplateFamily appTemplateFamily = TemplateFamilyBuilder.init("").setPath(subfolderPath).toTemplateFamily();
                    this.jsLibBuilder.addTemplateFamily(appTemplateFamily);
                    break;
                }
                case "js": {
                    this.jsLibBuilder.scanJavascriptFolder(this.resourceStorages, subfolderPath);
                    break;
                }
                case "ns-templates": {
                    this.addNamedTemplateFamilies(subfolderPath);
                }
            }
        }
    }

    private void addNamedTemplateFamilies(RelativePath folder) {
        SortedMap<String, RelativePath> subFolders = this.resourceStorages.listSubFolders(folder);
        for (Map.Entry<String, RelativePath> entry : subFolders.entrySet()) {
            String name = entry.getKey();
            RelativePath subfolderPath = entry.getValue();
            TemplateFamily appTemplateFamily = TemplateFamilyBuilder.init(name).setPath(subfolderPath).toTemplateFamily();
            this.jsLibBuilder.addTemplateFamily(appTemplateFamily);
        }
    }

    private JsLib toJsLib() {
        return this.jsLibBuilder.toJsLib();
    }
}

