/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.AbstractFicheXsltWriter;
import java.io.IOException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;

public class OdtFicheXsltWriter
extends AbstractFicheXsltWriter {
    public OdtFicheXsltWriter(BdfServer bdfServer, int extractVersion) {
        super(bdfServer, extractVersion);
    }

    public void add(Corpus corpus, boolean withCorpusCondition, boolean withLogo) throws IOException {
        if (corpus == null) {
            this.openMatchXslTemplate("fiche", null);
            this.closeXslTemplate();
            return;
        }
        if (withCorpusCondition) {
            this.openMatchXslTemplate("fiche[@corpus='" + corpus.getSubsetName() + "']", null);
        } else {
            this.openMatchXslTemplate("fiche", null);
        }
        this.appendUiComponents(corpus, this.uiManager.getMainUiComponents(corpus), withLogo);
        this.closeXslTemplate();
        this.addSeparator();
    }

    private void appendUiComponents(Corpus corpus, UiComponents uiComponents, boolean withLogo) throws IOException {
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        String subsetName = corpus.getSubsetName();
        this.addXslVariable("label", "$LABELS[@corpus='" + subsetName + "']/label", false);
        if (withLogo) {
            this.addSeparator();
            this.apply("/", "resource-Logo");
        }
        this.addSeparator();
        this.apply(".", "component-Header");
        this.addSeparator();
        if (uiComponents.contains(FieldKey.SUBTITLE)) {
            this.apply(this.tagNames.getSubtitleTagName(), "component-Header");
            this.addSeparator();
        }
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            if (uiComponent instanceof FieldUi) {
                this.appendFieldUi((FieldUi)uiComponent, corpusMetadata);
                continue;
            }
            if (uiComponent instanceof SpecialIncludeUi) {
                this.appendSpecialIncludeUi((SpecialIncludeUi)uiComponent);
                continue;
            }
            if (uiComponent instanceof SubsetIncludeUi) {
                this.appendSubsetIncludeUi((SubsetIncludeUi)uiComponent);
                continue;
            }
            if (uiComponent instanceof CommentUi || !(uiComponent instanceof DataUi)) continue;
            this.appendDataUi((DataUi)uiComponent);
        }
        this.appendChrono();
    }

    private void appendSpecialIncludeUi(SpecialIncludeUi includeUi) throws IOException {
        switch (includeUi.getName()) {
            case "liage": {
                this.apply(this.tagNames.getSubsetTagName((short)1) + "[@name='" + "liage" + "']", "component-Listitem", includeUi.getName());
            }
        }
    }
}

