/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.compilers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.text.StringUtils;

class PropertyPart {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private final String name;
    private final String mode;
    private final Map<String, String> optionMap;

    private PropertyPart(String name, String mode, Map<String, String> optionMap) {
        this.name = name;
        this.mode = mode;
        this.optionMap = optionMap;
    }

    public String getName() {
        return this.name;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean hasOption(String optionName) {
        return this.optionMap.containsKey(optionName);
    }

    public String getOptionValue(String optionName) {
        return this.optionMap.get(optionName);
    }

    static PropertyPart parse(String text) {
        String[] tokens = StringUtils.getTechnicalTokens(text, false);
        String name = "";
        String mode = "";
        Map<String, String> optionMap = EMPTY_MAP;
        int length = tokens.length;
        if (length > 0) {
            name = tokens[0];
        }
        if (length > 1) {
            mode = tokens[1];
        }
        if (length > 2) {
            optionMap = new HashMap<String, String>();
            for (int i = 2; i < length; ++i) {
                String token = tokens[i];
                int idx = token.indexOf(61);
                if (idx == -1) {
                    optionMap.put(token, "");
                    continue;
                }
                String optionName = token.substring(0, idx).trim();
                String optionValue = token.substring(idx + 1).trim();
                if (optionName.length() <= 0) continue;
                optionMap.put(optionName, optionValue);
            }
        }
        return new PropertyPart(name, mode, optionMap);
    }
}

