/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.diagnostic.urlscan;

import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlReport;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;

public class UrlInfo {
    private static final Map<String, FicheInfo> EMPTY_MAP = Collections.emptyMap();
    private final String url;
    private final UrlReport urlReport;
    private final Map<String, FicheInfo> ficheInfoMap;

    private UrlInfo(String url, UrlReport urlReport, Map<String, FicheInfo> ficheInfoMap) {
        this.url = url;
        this.urlReport = urlReport;
        this.ficheInfoMap = ficheInfoMap;
    }

    public String getUrl() {
        return this.url;
    }

    public UrlReport getUrlReport() {
        return this.urlReport;
    }

    public Map<String, FicheInfo> getFicheInfoMap() {
        return this.ficheInfoMap;
    }

    void add(FicheMeta ficheMeta, FieldKey fieldKey) {
        String globalId = ficheMeta.getGlobalId();
        FicheInfo ficheInfo = this.ficheInfoMap.get(globalId);
        if (ficheInfo == null) {
            ficheInfo = new FicheInfo(ficheMeta);
            this.ficheInfoMap.put(globalId, ficheInfo);
        }
        ficheInfo.add(fieldKey);
    }

    public static UrlInfo init(String url, UrlReport urlReport) {
        return new UrlInfo(url, urlReport, EMPTY_MAP);
    }

    static UrlInfo initWithFicheInfo(String url, UrlReport urlReport) {
        return new UrlInfo(url, urlReport, new TreeMap<String, FicheInfo>());
    }

    public static class FicheInfo {
        private final FicheMeta ficheMeta;
        private final Set<FieldKey> fieldKeySet = new LinkedHashSet<FieldKey>();

        private FicheInfo(FicheMeta ficheMeta) {
            this.ficheMeta = ficheMeta;
        }

        private void add(FieldKey fieldKey) {
            this.fieldKeySet.add(fieldKey);
        }

        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        public Set<FieldKey> getFieldKeySet() {
            return this.fieldKeySet;
        }
    }
}

