/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.balayage.BalayageConstants;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.SiteMapOption;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.tools.exportation.balayage.BalayageUnitBuilder;
import net.fichotheque.utils.SelectionUtils;
import net.mapeadores.util.localisation.LangContext;

public class BalayageBuilder {
    private final List<FicheQuery> globalFicheQuery = new ArrayList<FicheQuery>();
    private final List<BalayageUnitBuilder> unitList = new ArrayList<BalayageUnitBuilder>();
    private final List<String> externalScriptNameList = new ArrayList<String>();
    private final List<String> scrutariExportNameList = new ArrayList<String>();
    private final List<String> sqlExportNameList = new ArrayList<String>();
    private final BalayageDef balayageDef;
    private String defaultLangOption = "none";
    private LangContext langContext;
    private boolean withTransformation;
    private String rootName;
    private String path;
    private SiteMapOption siteMapOption;

    public BalayageBuilder(BalayageDef balayageDef) {
        this.balayageDef = balayageDef;
    }

    public BalayageBuilder addGlobalFicheQuery(FicheQuery ficheQuery) {
        this.globalFicheQuery.add(ficheQuery);
        return this;
    }

    public BalayageBuilder setRootName(String rootName) {
        this.rootName = rootName;
        return this;
    }

    public BalayageBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    public BalayageBuilder setWithTransformation(boolean withTransformation) {
        this.withTransformation = withTransformation;
        return this;
    }

    public BalayageBuilder addPostscriptumExternalScript(String name) {
        this.externalScriptNameList.add(name);
        return this;
    }

    public BalayageBuilder addPostscriptumScrutariExport(String name) {
        this.scrutariExportNameList.add(name);
        return this;
    }

    public BalayageBuilder addPostscriptumSqlExport(String name) {
        this.sqlExportNameList.add(name);
        return this;
    }

    public BalayageBuilder setDefaultLangOption(String defaultLangOption) {
        if ((defaultLangOption = BalayageConstants.checkLangOption(defaultLangOption)).equals("")) {
            defaultLangOption = "none";
        }
        this.defaultLangOption = defaultLangOption;
        return this;
    }

    public BalayageBuilder setLangContext(LangContext langContext) {
        this.langContext = langContext;
        return this;
    }

    public BalayageBuilder setSiteMapOption(SiteMapOption siteMapOption) {
        this.siteMapOption = siteMapOption;
        return this;
    }

    public BalayageUnitBuilder addBalayageUnitBuilder(String type) {
        BalayageUnitBuilder unitBuilder = new BalayageUnitBuilder(type);
        this.unitList.add(unitBuilder);
        return unitBuilder;
    }

    public void toBalayage() {
        List<FicheQuery> globalFicheQueryList = SelectionUtils.wrap(this.globalFicheQuery.toArray(new FicheQuery[this.globalFicheQuery.size()]));
    }

    public static BalayageBuilder init(BalayageDef balayageDef) {
        return new BalayageBuilder(balayageDef);
    }
}

