/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.managers.L10nManager;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.TrustedHtml;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.Labels;

public final class L10nUtils {
    private L10nUtils() {
    }

    @Nullable
    public static String getTitle(BdfServer bdfServer, Corpus corpus, UiComponent componentUi, Lang lang) {
        if (componentUi instanceof FieldUi) {
            CorpusField corpusField = corpus.getCorpusMetadata().getCorpusField(((FieldUi)componentUi).getFieldKey());
            if (corpusField != null) {
                return L10nUtils.getCorpusFieldTitle(corpusField, lang);
            }
            return null;
        }
        if (componentUi instanceof IncludeUi) {
            return L10nUtils.getIncludeTitle(bdfServer, (IncludeUi)componentUi, lang);
        }
        if (componentUi instanceof CommentUi) {
            return L10nUtils.getCommentTitle((CommentUi)componentUi, lang);
        }
        if (componentUi instanceof DataUi) {
            return L10nUtils.getDataTitle((DataUi)componentUi, lang);
        }
        return null;
    }

    @Nullable
    public static String getCommentTitle(CommentUi commentUi, Lang lang) {
        TrustedHtml html = commentUi.getHtmlByLang(lang);
        if (html != null) {
            String htmlString = html.toString();
            if (htmlString.length() > 33) {
                htmlString = htmlString.substring(0, 32) + "\u2026";
            }
            htmlString = htmlString.replace('\n', ' ');
            return htmlString;
        }
        return null;
    }

    @Nullable
    public static String getCorpusFieldTitle(CorpusField corpusField, Lang lang) {
        Label label = corpusField.getLabels().getLangPartCheckedLabel(lang);
        if (label != null) {
            return label.getLabelString();
        }
        return null;
    }

    @Nullable
    public static String getIncludeTitle(BdfServer bdfServer, IncludeUi includeUi, Lang lang) {
        Label label;
        Labels labels = includeUi.getCustomLabels();
        if (labels != null && (label = labels.getLangPartCheckedLabel(lang)) != null) {
            return label.getLabelString();
        }
        if (includeUi instanceof SpecialIncludeUi) {
            return L10nUtils.getSpecialIncludeTitle(bdfServer, includeUi.getName(), lang);
        }
        if (!(includeUi instanceof SubsetIncludeUi)) {
            return null;
        }
        ExtendedIncludeKey includeKey = ((SubsetIncludeUi)includeUi).getExtendedIncludeKey();
        SubsetKey subsetKey = includeKey.getSubsetKey();
        Subset subset = bdfServer.getFichotheque().getSubset(subsetKey);
        if (subset == null) {
            return null;
        }
        String title = FichothequeUtils.getTitle(subset, lang);
        if (title.equals(subsetKey.getKeyString())) {
            return null;
        }
        int weightFilter = includeKey.getWeightFilter();
        String mode = includeKey.getMode();
        if (mode.length() == 0 && weightFilter < 1) {
            return title;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(title);
        buf.append(" <");
        if (mode.length() > 0) {
            buf.append(mode);
            if (weightFilter > 0) {
                buf.append(", ");
                buf.append(weightFilter);
            }
        } else {
            buf.append(weightFilter);
        }
        buf.append('>');
        return buf.toString();
    }

    @Nullable
    public static String getSpecialIncludeTitle(BdfServer bdfServer, String specialIncludeName, Lang lang) {
        String messageKey = L10nUtils.getMessageKey(specialIncludeName);
        MessageLocalisation messageLocalisation = bdfServer.getL10nManager().getMessageLocalisation(lang);
        return messageLocalisation.toString(messageKey);
    }

    @Nullable
    public static String getDataTitle(DataUi dataUi, Lang lang) {
        Label label = dataUi.getLabels().getLangPartCheckedLabel(lang);
        if (label != null) {
            return label.getLabelString();
        }
        return null;
    }

    public static String toLabelString(FicheFormParameters ficheFormParameters, CorpusField corpusField) {
        String label = L10nUtils.getCorpusFieldTitle(corpusField, ficheFormParameters.getWorkingLang());
        if (label != null) {
            return label;
        }
        return corpusField.getFieldString();
    }

    public static String toLabelString(FicheFormParameters ficheFormParameters, IncludeUi includeUi) {
        String label = L10nUtils.getIncludeTitle(ficheFormParameters.getBdfServer(), includeUi, ficheFormParameters.getWorkingLang());
        if (label != null) {
            return label;
        }
        return includeUi.getName();
    }

    public static Labels toLabels(L10nManager l10nManager, ThesaurusFieldKey thesaurusFieldKey, Langs langs) {
        LabelChangeBuilder builder = new LabelChangeBuilder();
        String messageKey = L10nUtils.getMessageKey(thesaurusFieldKey);
        for (Lang lang : langs) {
            String labelString;
            MessageLocalisation messageLocalisation = l10nManager.getMessageLocalisation(lang);
            String value = null;
            if (thesaurusFieldKey.isLabelThesaurusFieldKey()) {
                value = messageLocalisation.toString(thesaurusFieldKey.getLang().toString());
            }
            if ((labelString = value == null ? messageLocalisation.toString(messageKey) : messageLocalisation.toString(messageKey, value)) == null) continue;
            builder.putLabel(lang, labelString);
        }
        return builder.toLabels();
    }

    public static Labels toLabels(L10nManager l10nManager, String specialIncludeName, Langs langs) {
        LabelChangeBuilder builder = new LabelChangeBuilder();
        String messageKey = L10nUtils.getMessageKey(specialIncludeName);
        for (Lang lang : langs) {
            MessageLocalisation messageLocalisation = l10nManager.getMessageLocalisation(lang);
            String labelString = messageLocalisation.toString(messageKey);
            if (labelString == null) continue;
            builder.putLabel(lang, labelString);
        }
        return builder.toLabels();
    }

    public static String getMessageKey(ThesaurusFieldKey thesaurusFieldKey) {
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.ID)) {
            return "_ alias.motcle.id";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA)) {
            return "_ alias.motcle.idalpha";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_ID)) {
            return "_ alias.motcle.parent_id";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_IDALPHA)) {
            return "_ alias.motcle.parent_idalpha";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.BABELIENLABEL)) {
            return "_ alias.motcle.label";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.BABELIENLANG)) {
            return "_ alias.motcle.lang";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.POSITION_LOCAL)) {
            return "_ alias.motcle.pos_loc";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.POSITION_GLOBAL)) {
            return "_ alias.motcle.pos_glob";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.LEVEL)) {
            return "_ alias.motcle.level";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.THIS)) {
            return "_ alias.motcle.this";
        }
        if (thesaurusFieldKey.equals(ThesaurusFieldKey.STATUS)) {
            return "_ alias.motcle.status";
        }
        if (thesaurusFieldKey.isLabelThesaurusFieldKey()) {
            return "_ alias.motcle.label_lang";
        }
        throw new SwitchException("Unknown thesaurusFieldKey: " + thesaurusFieldKey.toString());
    }

    public static String getMessageKey(FieldKey fieldKey) {
        switch (fieldKey.getKeyString()) {
            case "title": {
                return "_ alias.fiche.title";
            }
            case "subtitle": {
                return "_ alias.fiche.subtitle";
            }
            case "lang": {
                return "_ alias.fiche.lang";
            }
            case "owners": {
                return "_ alias.fiche.owners";
            }
            case "id": {
                return "_ alias.fiche.id";
            }
        }
        throw new IllegalArgumentException("Not a special field key: " + fieldKey.getKeyString());
    }

    public static String getMessageKey(String specialIncludeName) {
        switch (specialIncludeName) {
            case "liage": {
                return "_ alias.include.liage";
            }
            case "parentage": {
                return "_ alias.include.parentage";
            }
            case "date_creation": {
                return "_ alias.include.date_creation";
            }
            case "date_modification": {
                return "_ alias.include.date_modification";
            }
        }
        throw new SwitchException("Unknown include name: " + specialIncludeName);
    }
}

