/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.api.storage.TemplateStorage;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.conf.ConfDirs;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.StorageDirectoryUtils;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import fr.exemole.bdfserver.tools.storage.TemplateStorageUnitBuilder;
import fr.exemole.bdfserver.xml.transformation.TemplateDefXMLPart;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.transformation.TemplateDef;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.tools.exportation.transformation.TemplateDefBuilder;
import net.fichotheque.tools.exportation.transformation.dom.TemplateDefDOMReader;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.ValidExtension;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class TemplateStorageImpl
implements TemplateStorage {
    private final StorageDirectory transformationDirectory;

    public TemplateStorageImpl(BdfServerDirs dirs) {
        this.transformationDirectory = StorageDirectoryUtils.toStorageDirectory((ConfDirs)dirs, "transformationdata");
    }

    @Override
    public TemplateStorage.Unit[] checkStorage() {
        TreeMap<TemplateKey, TemplateStorage.Unit> map = new TreeMap<TemplateKey, TemplateStorage.Unit>();
        File dataDir = this.transformationDirectory.getDataDir();
        if (dataDir.exists()) {
            for (File transformationDir : dataDir.listFiles()) {
                if (!transformationDir.isDirectory()) continue;
                String transformationName = transformationDir.getName();
                try {
                    TransformationKey transformationKey = TransformationKey.parse(transformationName);
                    for (File templateDir : transformationDir.listFiles()) {
                        TemplateKey templateKey;
                        if (!templateDir.isDirectory()) continue;
                        String templateName = templateDir.getName();
                        int idx = templateName.indexOf(46);
                        if (idx != -1) {
                            try {
                                ValidExtension validExtension = ValidExtension.parse(templateName.substring(idx + 1));
                                templateKey = TemplateKey.parse(transformationKey, validExtension, templateName.substring(0, idx));
                            }
                            catch (ParseException pe) {
                                continue;
                            }
                        }
                        try {
                            templateKey = TemplateKey.parse(transformationKey, templateName);
                        }
                        catch (ParseException pe) {
                            continue;
                        }
                        map.put(templateKey, this.buildUnit(templateDir, templateKey));
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return map.values().toArray(new TemplateStorage.Unit[map.size()]);
    }

    @Override
    public TemplateStorage.Unit getTemplateStorageUnit(TemplateKey templateKey) {
        String completePath = this.getCompletePath(templateKey, null);
        File varDir = this.transformationDirectory.getDataFile(completePath);
        return this.buildUnit(varDir, templateKey);
    }

    @Override
    public void saveTemplateDef(TemplateDef templateDef, EditOrigin editOrigin) {
        StorageFile storageFile = this.getStorageFile(templateDef.getTemplateKey(), "_def.xml");
        try (BufferedWriter writer = storageFile.archiveAndGetWriter(editOrigin);){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(writer);
            xmlWriter.appendXMLDeclaration();
            TemplateDefXMLPart xmlPart = new TemplateDefXMLPart(xmlWriter);
            xmlPart.addTemplateDef(templateDef);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    @Override
    public StorageContent getStorageContent(TemplateKey templateKey, String contentPath) {
        if (templateKey.isDist()) {
            return null;
        }
        if ((contentPath = TemplateStorageImpl.checkPath(contentPath)) == null) {
            return null;
        }
        StorageFile storageFile = this.getStorageFile(templateKey, contentPath);
        if (!storageFile.exists()) {
            return null;
        }
        return StorageUtils.toStorageContent(contentPath, storageFile.getFile());
    }

    @Override
    public void saveStorageContent(TemplateKey templateKey, String contentPath, InputStream inputStream, EditOrigin editOrigin) throws IOException {
        if (templateKey.isDist()) {
            throw new IllegalArgumentException("templateKey is dist key");
        }
        if ((contentPath = TemplateStorageImpl.checkPath(contentPath)) == null) {
            return;
        }
        StorageFile storageFile = this.getStorageFile(templateKey, contentPath);
        try (BufferedOutputStream os = storageFile.archiveAndGetOutputStream(editOrigin);){
            IOUtils.copy(inputStream, (OutputStream)os);
        }
    }

    @Override
    public boolean removeStorageContent(TemplateKey templateKey, String contentPath, EditOrigin editOrigin) {
        if (templateKey.isDist()) {
            throw new IllegalArgumentException("templateKey is default key");
        }
        if ((contentPath = TemplateStorageImpl.checkPath(contentPath)) == null) {
            return false;
        }
        StorageFile storageFile = this.getStorageFile(templateKey, contentPath);
        if (!storageFile.exists()) {
            return false;
        }
        storageFile.archiveAndDelete(editOrigin);
        return true;
    }

    @Override
    public void createTemplate(TemplateStorage.Unit templateStorageDescription, EditOrigin editOrigin) throws IOException {
        String completePath = this.getCompletePath(templateStorageDescription.getTemplateKey(), null);
        StorageFile transformationDir = this.transformationDirectory.getStorageFile(completePath);
        if (transformationDir.exists()) {
            transformationDir.delete();
        }
        for (StorageContent content : templateStorageDescription.getStorageContentList()) {
            String path = content.getPath();
            if ((path = StringUtils.normalizeRelativePath(path)) == null) continue;
            StorageFile storageFile = transformationDir.getSubStorageFile(path);
            InputStream is = content.getInputStream();
            try {
                BufferedOutputStream os = storageFile.archiveAndGetOutputStream(editOrigin);
                try {
                    IOUtils.copy(is, (OutputStream)os);
                }
                finally {
                    if (os == null) continue;
                    ((OutputStream)os).close();
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        this.saveTemplateDef(templateStorageDescription.getTemplateDef(), editOrigin);
        StorageFile typeFile = transformationDir.getSubStorageFile("_type");
        try (BufferedWriter writer = typeFile.archiveAndGetWriter(editOrigin);){
            writer.write(templateStorageDescription.getType());
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    @Override
    public boolean removeTemplate(TemplateKey templateKey, EditOrigin editOrigin) {
        String completePath = this.getCompletePath(templateKey, null);
        StorageFile transformationDir = this.transformationDirectory.getStorageFile(completePath);
        if (!transformationDir.exists() || !transformationDir.isDirectory()) {
            return false;
        }
        StorageDirectoryUtils.archiveAndDeleteDirectory(transformationDir, editOrigin);
        return true;
    }

    private TemplateStorage.Unit buildUnit(File templateDir, TemplateKey templateKey) {
        String type = "";
        TemplateStorageUnitBuilder templateStorageUnitBuilder = new TemplateStorageUnitBuilder();
        TemplateDefBuilder templateDefBuilder = new TemplateDefBuilder(templateKey);
        for (File file : templateDir.listFiles()) {
            String fileName = file.getName();
            if (fileName.equals("_type")) {
                try (FileInputStream is = new FileInputStream(file);){
                    type = IOUtils.toString(is, "UTF-8").trim();
                    continue;
                }
                catch (IOException ioe) {
                    throw new BdfStorageException(ioe);
                }
            }
            if (fileName.equals("_def.xml")) {
                StorageFile defFile = this.getStorageFile(templateKey, fileName);
                Document doc = defFile.readDocument();
                TemplateDefDOMReader.init(templateDefBuilder, LogUtils.NULL_MESSAGEHANDLER).read(doc.getDocumentElement());
                continue;
            }
            if (file.isDirectory()) {
                templateStorageUnitBuilder.populate(file, "");
                continue;
            }
            templateStorageUnitBuilder.addStorageContent(file.getName(), file);
        }
        templateStorageUnitBuilder.setType(type).setTemplateDef(templateDefBuilder.toTemplateDef());
        return templateStorageUnitBuilder.toTemplateStorageUnit();
    }

    private String getCompletePath(TemplateKey templateKey, String path) {
        StringBuilder buf = new StringBuilder();
        buf.append(templateKey.getTransformationKey());
        buf.append(File.separatorChar);
        buf.append(templateKey.getCompleteName());
        if (path != null) {
            buf.append(File.separatorChar);
            buf.append(path);
        }
        return buf.toString();
    }

    private StorageFile getStorageFile(TemplateKey templateKey, String path) {
        String completePath = this.getCompletePath(templateKey, path);
        return this.transformationDirectory.getStorageFile(completePath);
    }

    private static String checkPath(String path) {
        if ((path = StringUtils.normalizeRelativePath(path)) == null) {
            return null;
        }
        switch (path) {
            case "_def.xml": 
            case "_type": {
                return null;
            }
        }
        return path;
    }
}

