/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.commands.CoreBdfCommandProvider;
import fr.exemole.bdfserver.html.MessageHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.CoreHtmlProducerProvider;
import fr.exemole.bdfserver.jsonproducers.CoreJsonProducerProvider;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.BdfCommandParametersBuilder;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import fr.exemole.bdfserver.tools.instruction.OutputParametersBuilder;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.OutputInfo;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.servlets.handlers.RedirectResponseHandler;
import net.mapeadores.util.servlets.handlers.ResponseHandlerFactory;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;

public class DomainInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final RequestMap requestMap;
    private final BdfCommand bdfCommand;
    private final boolean noCommand;
    private final Domain domain;
    private final CommandMessage initErrorMessage;
    private BdfUser bdfUser;

    public DomainInstruction(BdfServer bdfServer, RequestMap requestMap, Domain domain) {
        this.bdfServer = bdfServer;
        this.requestMap = requestMap;
        this.domain = domain;
        String cmd = requestMap.getParameter("cmd");
        if (cmd != null) {
            this.noCommand = false;
            BdfCommandParameters bdfCommandParameters = BdfCommandParametersBuilder.build(cmd, domain, bdfServer, requestMap);
            BdfCommand bdfCmd = BdfServerUtils.getExtensionBdfCommand(bdfCommandParameters);
            if (bdfCmd == null) {
                bdfCmd = CoreBdfCommandProvider.UNIQUE_INSTANCE.getBdfCommand(bdfCommandParameters);
            }
            if (bdfCmd != null) {
                this.bdfCommand = bdfCmd;
                this.initErrorMessage = null;
            } else {
                this.bdfCommand = null;
                this.initErrorMessage = LogUtils.error("_ error.unknown.bdfcommand", cmd);
            }
        } else {
            this.noCommand = true;
            this.bdfCommand = null;
            this.initErrorMessage = null;
        }
    }

    @Override
    public short getBdfUserNeed() {
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        ResponseHandler responseHandler = this.run(bdfUser);
        if (responseHandler instanceof JsonResponseHandler) {
            ((JsonResponseHandler)responseHandler).giveAccess(this.requestMap);
        }
        return responseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseHandler run(BdfUser bdfUser) {
        BdfCommandResult bdfCommandResult;
        this.bdfUser = bdfUser;
        if (this.noCommand) {
            return this.getResponseHandler(null);
        }
        if (this.initErrorMessage != null) {
            return this.getMessageHandler(this.initErrorMessage);
        }
        if (this.requestMap.isTrue("test")) {
            return this.getMessageHandler(this.bdfCommand.testCommand(bdfUser));
        }
        if (this.bdfCommand.needSynchronisation()) {
            BdfServer bdfServer = this.bdfServer;
            synchronized (bdfServer) {
                bdfCommandResult = this.bdfCommand.doCommand(bdfUser);
            }
        } else {
            bdfCommandResult = this.bdfCommand.doCommand(bdfUser);
        }
        return this.getResponseHandler(bdfCommandResult);
    }

    private ResponseHandler getResponseHandler(BdfCommandResult bdfCommandResult) {
        String redirect = this.requestMap.getParameter("redirect");
        if (redirect != null && redirect.length() > 0) {
            return new RedirectResponseHandler(redirect);
        }
        OutputInfo outputInfo = OutputInfo.buildFromRequest(this.requestMap, DomainInstruction.getDefaultPage(this.domain));
        switch (outputInfo.getType()) {
            case 2: {
                return this.getJsonResponseHandler(outputInfo, bdfCommandResult);
            }
            case 3: {
                return this.getPageResponseHandler(outputInfo, bdfCommandResult);
            }
            case 1: {
                return this.getStreamResponseHandler(outputInfo, bdfCommandResult);
            }
        }
        return this.getHtmlMessageHandler(bdfCommandResult, LogUtils.error("_ error.empty.page", new Object[0]));
    }

    private ResponseHandler getJsonResponseHandler(OutputInfo outputInfo, BdfCommandResult bdfCommandResult) {
        JsonProducer jsonProducer = this.getJsonProducer(outputInfo, bdfCommandResult);
        return JsonResponseHandler.build(jsonProducer, this.requestMap);
    }

    private ResponseHandler getPageResponseHandler(OutputInfo outputInfo, BdfCommandResult bdfCommandResult) {
        String errorPage;
        if (!outputInfo.hasOutput()) {
            return this.getHtmlMessageHandler(bdfCommandResult, LogUtils.error("_ error.empty.page", new Object[0]));
        }
        String page = outputInfo.getOutput();
        if (bdfCommandResult != null && bdfCommandResult.isError() && (errorPage = this.requestMap.getParameter("page-err")) != null) {
            page = errorPage;
        }
        OutputParameters outputParameters = this.buildOutputParameters(page, bdfCommandResult);
        try {
            HtmlProducer htmlProducer = BdfServerUtils.getExtensionHtmlProducer(outputParameters);
            if (htmlProducer == null) {
                htmlProducer = CoreHtmlProducerProvider.UNIQUE_INSTANCE.getHtmlProducer(outputParameters);
            }
            if (htmlProducer == null) {
                return this.getHtmlMessageHandler(bdfCommandResult, LogUtils.error("_ error.unknown.page", page));
            }
            return HtmlResponseHandler.init(htmlProducer);
        }
        catch (ErrorMessageException eme) {
            return this.getHtmlMessageHandler(bdfCommandResult, eme.getErrorMessage());
        }
    }

    private ResponseHandler getStreamResponseHandler(OutputInfo outputInfo, BdfCommandResult bdfCommandResult) {
        if (bdfCommandResult != null && bdfCommandResult.isError()) {
            return this.getHtmlMessageHandler(null, bdfCommandResult.getCommandMessage());
        }
        if (!outputInfo.hasOutput()) {
            return this.getHtmlMessageHandler(bdfCommandResult, LogUtils.error("_ error.empty.mandatoryparameter", "stream"));
        }
        String output = outputInfo.getOutput();
        OutputParameters outputParameters = this.buildOutputParameters(output, bdfCommandResult);
        try {
            StreamProducer streamProducer = BdfServerUtils.getExtensionStreamProducer(outputParameters);
            if (streamProducer == null) {
                return this.getHtmlMessageHandler(bdfCommandResult, LogUtils.error("_ error.unknown.parametervalue", "stream", output));
            }
            return StreamResponseHandler.init(streamProducer);
        }
        catch (ErrorMessageException eme) {
            return this.getHtmlMessageHandler(bdfCommandResult, eme.getErrorMessage());
        }
    }

    private JsonProducer getJsonProducer(OutputInfo outputInfo, BdfCommandResult bdfCommandResult) {
        if (bdfCommandResult != null && bdfCommandResult.isError()) {
            return this.getDefaultJsonProducer(null, bdfCommandResult.getCommandMessage());
        }
        String json = outputInfo.hasOutput() ? outputInfo.getOutput() : "_default";
        if (json.equals("_default")) {
            if (bdfCommandResult != null) {
                return this.getDefaultJsonProducer(bdfCommandResult, null);
            }
            return this.getDefaultJsonProducer(null, LogUtils.error("_ error.exception.unabletodefinejson", new Object[0]));
        }
        OutputParameters outputParameters = this.buildOutputParameters(json, bdfCommandResult);
        try {
            JsonProducer jsonProducer = BdfServerUtils.getExtensionJsonProducer(outputParameters);
            if (jsonProducer == null) {
                jsonProducer = CoreJsonProducerProvider.UNIQUE_INSTANCE.getJsonProducer(outputParameters);
            }
            if (jsonProducer == null) {
                return this.getDefaultJsonProducer(bdfCommandResult, LogUtils.error("_ error.unknown.json", json));
            }
            return jsonProducer;
        }
        catch (ErrorMessageException eme) {
            return this.getDefaultJsonProducer(bdfCommandResult, eme.getErrorMessage());
        }
    }

    private JsonProducer getDefaultJsonProducer(BdfCommandResult bdfCommandResult, CommandMessage errorMessage) {
        MessageLocalisation messageLocalisation = this.bdfServer.getL10nManager().getMessageLocalisation(this.bdfUser);
        return BdfInstructionUtils.getDefaultJsonProducer(messageLocalisation, bdfCommandResult, errorMessage);
    }

    private ResponseHandler getMessageHandler(CommandMessage commandMessage) {
        if (RequestUtils.isJsonDefined(this.requestMap)) {
            MessageLocalisation messageLocalisation = this.bdfServer.getL10nManager().getMessageLocalisation(this.bdfUser);
            return ResponseHandlerFactory.getJsonInstance(messageLocalisation, this.requestMap, commandMessage);
        }
        return this.getHtmlMessageHandler(null, commandMessage);
    }

    private ResponseHandler getHtmlMessageHandler(BdfCommandResult bdfCommandResult, CommandMessage commandMessage) {
        return HtmlResponseHandler.init(MessageHtmlProducer.init(new DefaultBdfParameters(this.bdfServer, this.bdfUser)).addMessages(commandMessage).setBdfCommandResult(bdfCommandResult));
    }

    private OutputParameters buildOutputParameters(String output, BdfCommandResult bdfCommandResult) {
        return OutputParametersBuilder.build(output, this.domain, this.bdfServer, this.requestMap, this.bdfUser, bdfCommandResult);
    }

    private static String getDefaultPage(Domain domain) {
        if (domain.getSecondPart().isEmpty()) {
            return null;
        }
        switch (domain.getFirstPart()) {
            case "administration": 
            case "album": 
            case "configuration": 
            case "corpus": 
            case "mailing": 
            case "exportation": 
            case "edition": 
            case "selection": 
            case "sphere": 
            case "thesaurus": 
            case "main": 
            case "misc": 
            case "addenda": 
            case "importation": 
            case "pioche": {
                return domain.getSecondPart();
            }
        }
        return null;
    }
}

