/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.jsonproducers.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.tools.FichothequeInfo;
import fr.exemole.bdfserver.storage.directory.tools.SphereChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;

public class CentralSphereStatsJsonProperty
implements JsonProperty {
    public static final String NOT_HERE = "no";
    public static final String HERE = "here";
    private final Multi multi;
    private final CentralSphere centralSphere;
    private final Lang lang;

    public CentralSphereStatsJsonProperty(Multi multi, CentralSphere centralSphere, Lang lang) {
        this.multi = multi;
        this.centralSphere = centralSphere;
        this.lang = lang;
    }

    @Override
    public String getName() {
        return "stats";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        List<StatInfo> statInfoList = this.scan();
        jw.object();
        jw.key("fichothequeArray");
        jw.array();
        for (StatInfo statInfo : statInfoList) {
            this.write(jw, statInfo);
        }
        jw.endArray();
        jw.endObject();
    }

    private List<StatInfo> scan() {
        ArrayList<StatInfo> statInfoList = new ArrayList<StatInfo>();
        for (String name : this.multi.getExistingNameSet()) {
            StatInfo statInfo;
            BdfServer bdfServer = this.multi.getInitBdfServer(name);
            if (bdfServer != null) {
                statInfo = this.getStatInfo(name, bdfServer);
            } else {
                BdfServerDirs bdfServerDirs = this.multi.getBdfServerDirs(name);
                statInfo = this.getStatInfo(name, bdfServerDirs);
            }
            statInfoList.add(statInfo);
        }
        return statInfoList;
    }

    private StatInfo getStatInfo(String name, BdfServer bdfServer) {
        Sphere sphere = (Sphere)bdfServer.getFichotheque().getSubset(this.centralSphere.getSphereKey());
        if (sphere == null) {
            return new StatInfo(name, bdfServer, false);
        }
        StatInfo statInfo = new StatInfo(name, bdfServer, true);
        for (Redacteur redacteur : sphere.getRedacteurList()) {
            String login = redacteur.getLogin();
            if (!this.centralSphere.hasCentralUser(login)) {
                statInfo.addOutside(login);
                continue;
            }
            statInfo.checkRedacteur(redacteur);
        }
        return statInfo;
    }

    private StatInfo getStatInfo(String name, BdfServerDirs bdfServerDirs) {
        boolean here = SphereChecker.containsSphere(this.centralSphere.getSphereKey(), bdfServerDirs);
        return new StatInfo(name, bdfServerDirs, here);
    }

    private void write(JSONWriter jw, StatInfo statInfo) throws IOException {
        jw.object();
        jw.key("fichothequeName").value(statInfo.getName());
        jw.key("fichothequeTitle").value(statInfo.getFichothequeTitle(this.lang));
        jw.key("fichothequeInit").value(statInfo.isInit());
        jw.key(HERE).value(statInfo.isHere());
        jw.key("loginArrays");
        jw.object();
        this.writeArray(jw, "active", statInfo.activeSet);
        this.writeArray(jw, "readonly", statInfo.readonlySet);
        this.writeArray(jw, "inactive", statInfo.inactiveSet);
        this.writeArray(jw, "outside", statInfo.outsideSet);
        jw.endObject();
        jw.endObject();
    }

    private void writeArray(JSONWriter jw, String key, Collection<String> collection) throws IOException {
        jw.key(key);
        jw.array();
        for (String login : collection) {
            jw.value(login);
        }
        jw.endArray();
    }

    private static class StatInfo
    extends FichothequeInfo {
        private final boolean here;
        private final SortedSet<String> activeSet = new TreeSet<String>();
        private final SortedSet<String> readonlySet = new TreeSet<String>();
        private final SortedSet<String> inactiveSet = new TreeSet<String>();
        private final SortedSet<String> outsideSet = new TreeSet<String>();

        public StatInfo(String name, BdfServer bdfServer, boolean here) {
            super(name, bdfServer);
            this.here = here;
        }

        public StatInfo(String name, BdfServerDirs bdfServerDirs, boolean here) {
            super(name, bdfServerDirs);
            this.here = here;
        }

        public boolean isHere() {
            return this.here;
        }

        public void addOutside(String login) {
            this.outsideSet.add(login);
        }

        public void checkRedacteur(Redacteur redacteur) {
            String login = redacteur.getLogin();
            switch (redacteur.getStatus()) {
                case "inactive": {
                    this.inactiveSet.add(login);
                    break;
                }
                case "readonly": {
                    this.readonlySet.add(login);
                    break;
                }
                default: {
                    this.activeSet.add(login);
                }
            }
        }
    }
}

