/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.impl;

import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralSphereEditor;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.api.central.CentralUserEditor;
import fr.exemole.bdfserver.multi.impl.CentralSphereMetadataImpl;
import fr.exemole.bdfserver.multi.impl.CentralUserImpl;
import fr.exemole.bdfserver.multi.impl.MultiStorageFileCatalog;
import fr.exemole.bdfserver.multi.tools.dom.CentralSphereMetadataDOMReader;
import fr.exemole.bdfserver.multi.tools.dom.CentralUserDOMReader;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.File;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.Metadata;
import net.fichotheque.MetadataEditor;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.LoginKey;
import net.mapeadores.util.logging.LogUtils;
import org.w3c.dom.Document;

public class CentralSphereImpl
implements CentralSphere {
    private final StorageDirectory storageDirectory;
    private final SubsetKey sphereKey;
    private final CentralSphereMetadataImpl metadata;
    private final SortedMap<String, CentralUserImpl> centralUserMap = new TreeMap<String, CentralUserImpl>();
    private final Set<String> loginSet = Collections.unmodifiableSet(this.centralUserMap.keySet());

    public CentralSphereImpl(StorageDirectory storageDirectory, SubsetKey sphereKey) {
        this.storageDirectory = storageDirectory;
        this.sphereKey = sphereKey;
        this.metadata = new CentralSphereMetadataImpl();
    }

    @Override
    public SubsetKey getSphereKey() {
        return this.sphereKey;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public CentralUser getCentralUser(String login) {
        return (CentralUser)this.centralUserMap.get(login);
    }

    @Override
    public Set<String> getLoginSet() {
        return this.loginSet;
    }

    public CentralSphereEditor getCentralSphereEditor(EditOrigin editOrigin) {
        return new InternalCentralSphereEditor(this, editOrigin);
    }

    public boolean saveChanges(CentralSphereEditor centralSphereEditor) {
        InternalCentralSphereEditor internalCentralSphereEditor = (InternalCentralSphereEditor)centralSphereEditor;
        return internalCentralSphereEditor.saveChanges(this.storageDirectory);
    }

    public static CentralSphereImpl build(StorageDirectory storageDirectory, String name) {
        String usersPath;
        File usersDir;
        SubsetKey sphereKey;
        try {
            sphereKey = SubsetKey.parse((short)3, name);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        CentralSphereImpl centralSphere = new CentralSphereImpl(storageDirectory, sphereKey);
        CentralSphereEditor centralSphereEditor = centralSphere.getCentralSphereEditor(null);
        StorageFile centralSphereMetadataFile = MultiStorageFileCatalog.centralSphereMetadata(storageDirectory, name);
        if (centralSphereMetadataFile.exists()) {
            Document document = centralSphereMetadataFile.readDocument();
            CentralSphereMetadataDOMReader reader = new CentralSphereMetadataDOMReader(centralSphereEditor.getMetadataEditor(), LogUtils.NULL_MESSAGEHANDLER);
            reader.read(document.getDocumentElement());
        }
        if ((usersDir = storageDirectory.getDataDir(usersPath = "spheres" + File.separator + name + File.separator + "users")).exists()) {
            for (File file : usersDir.listFiles()) {
                String userFileName = file.getName();
                if (!userFileName.endsWith(".xml")) continue;
                String login = userFileName.substring(0, userFileName.length() - 4);
                try {
                    LoginKey loginKey = LoginKey.parse(sphereKey, login);
                    CentralUserImpl centralUserImpl = new CentralUserImpl(loginKey);
                    centralSphere.centralUserMap.put(loginKey.getLogin(), centralUserImpl);
                    StorageFile userStorageFile = storageDirectory.getStorageFile(usersPath + File.separator + userFileName);
                    Document document = userStorageFile.readDocument();
                    CentralUserDOMReader reader = new CentralUserDOMReader(centralUserImpl.getCentalUserEditor(null), LogUtils.NULL_MESSAGEHANDLER);
                    reader.read(document.getDocumentElement());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return centralSphere;
    }

    private static class InternalCentralSphereEditor
    implements CentralSphereEditor {
        private final CentralSphereImpl centralSphere;
        private final EditOrigin editOrigin;
        private final Map<String, CentralUserImpl.CentralUserEditorImpl> userEditorMap = new HashMap<String, CentralUserImpl.CentralUserEditorImpl>();
        private CentralSphereMetadataImpl.CentralSphereMetadataEditorImpl metadataEditor = null;

        private InternalCentralSphereEditor(CentralSphereImpl centralSphere, EditOrigin editOrigin) {
            this.centralSphere = centralSphere;
            this.editOrigin = editOrigin;
        }

        @Override
        public CentralUserEditor createCentralUser(String login) {
            if (this.centralSphere.hasCentralUser(login)) {
                throw new IllegalArgumentException("existing login: " + login);
            }
            try {
                LoginKey loginKey = LoginKey.parse(this.centralSphere.getSphereKey(), login);
                CentralUserImpl centralUserImpl = new CentralUserImpl(loginKey);
                this.centralSphere.centralUserMap.put(loginKey.getLogin(), centralUserImpl);
                return this.getCentralUserEditor(login);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Wrong login: " + login);
            }
        }

        @Override
        public MetadataEditor getMetadataEditor() {
            if (this.metadataEditor == null) {
                this.metadataEditor = this.centralSphere.metadata.getSphereMetadataEditor(this.editOrigin);
            }
            return this.metadataEditor;
        }

        @Override
        public CentralUserEditor getCentralUserEditor(String login) {
            CentralUserImpl.CentralUserEditorImpl centralUserEditor = this.userEditorMap.get(login);
            if (centralUserEditor != null) {
                return centralUserEditor;
            }
            CentralUserImpl centralUser = (CentralUserImpl)this.centralSphere.centralUserMap.get(login);
            if (centralUser == null) {
                return null;
            }
            centralUserEditor = centralUser.getCentalUserEditor(this.editOrigin);
            this.userEditorMap.put(login, centralUserEditor);
            return centralUserEditor;
        }

        private boolean saveChanges(StorageDirectory bdfdataDirectory) {
            boolean metadataSaved;
            boolean done = false;
            if (this.metadataEditor != null && (metadataSaved = this.metadataEditor.saveChanges(bdfdataDirectory, this.centralSphere.getName()))) {
                done = true;
            }
            for (CentralUserImpl.CentralUserEditorImpl centralUserEditor : this.userEditorMap.values()) {
                boolean userSaved = centralUserEditor.saveChanges(bdfdataDirectory);
                if (!userSaved) continue;
                done = true;
            }
            return true;
        }
    }
}

