/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.commands.thesaurus.MotcleRemoveCommand;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.main.MainHtmlUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlUtils;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.localisation.Lang;

public class MotcleChangeFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Thesaurus thesaurus;
    private final Motcle motcle;
    private final boolean withFontAwesome;

    public MotcleChangeFormHtmlProducer(BdfParameters bdfParameters, Motcle motcle) {
        super(bdfParameters);
        this.thesaurus = motcle.getThesaurus();
        this.motcle = motcle;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addThemeCss("thesaurus.css");
        this.withFontAwesome = this.checkFontAwesome();
    }

    @Override
    public void printHtml() {
        ThesaurusMetadata thsmeta = this.thesaurus.getThesaurusMetadata();
        short thesaurusType = thsmeta.getThesaurusType();
        boolean withIdalpha = thesaurusType == 2;
        Lang thesaurusLang = BdfServerUtils.checkLangDisponibility(this.bdfServer, this.thesaurus, this.workingLang);
        this.start();
        ThesaurusHtmlUtils.printMotcleToolBar(this, this.bdfServer, this.bdfUser, this.motcle, "motcle-changeform", thesaurusLang, this.withFontAwesome);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("thesaurus").family("THS").veil(true).page("motcle-changeform");
        if (withIdalpha) {
            ThesaurusCommandBoxUtils.printIdalphaChangeBox(this, commandBox, this.motcle);
        }
        ThesaurusCommandBoxUtils.printParentChangeBox(this, commandBox, this.motcle, this.workingLang);
        ThesaurusCommandBoxUtils.printLabelChangeBox(this, commandBox, this.motcle, this.bdfServer);
        MotcleStats motcleStats = this.getStats();
        this.__(PageUnit.start("_ title.thesaurus.indexation")).__(this.printIndexation(motcleStats)).__(PageUnit.END);
        if (motcleStats.hasSatellite()) {
            this.__(PageUnit.start("_ link.global.satellites")).__(this.printSatellite(motcleStats)).__(PageUnit.END);
        }
        ThesaurusCommandBoxUtils.printMotcleStatusBox(this, commandBox, this.motcle);
        if (MotcleRemoveCommand.isRemoveCandidate(this.bdfServer, this.motcle)) {
            commandBox.page("_message").errorPage("motcle-changeform");
            ThesaurusCommandBoxUtils.printMotcleRemoveBox(this, commandBox, this.motcle, this.bdfUser.getWorkingLang(), this.bdfUser.getFormatLocale());
        }
        this.end();
    }

    private MotcleStats getStats() {
        MotcleStats motcleStats = new MotcleStats();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            FicheMeta ficheMeta;
            if (FichothequeUtils.isParentageCorpus(corpus, this.thesaurus) && (ficheMeta = corpus.getFicheMetaById(this.motcle.getId())) != null) {
                motcleStats.addSatellite(ficheMeta);
            }
            motcleStats.addFicheCount(this.motcle.getCroisements(corpus).getEntryList().size());
        }
        return motcleStats;
    }

    private boolean printLabel(int ficheCount) {
        if (ficheCount == 1) {
            this.__localize("_ info.thesaurus.indexation_one");
        } else {
            this.__localize("_ info.thesaurus.indexation_many", ficheCount);
        }
        return true;
    }

    private boolean printIndexation(MotcleStats motcleStats) {
        int ficheCount = motcleStats.getFicheCount();
        if (ficheCount == 0) {
            this.P("global-Warning").__localize("_ info.thesaurus.indexation_none")._P();
        } else {
            this.P().__(this.printLabel(ficheCount)).__space().SPAN("global-SmallLinks").__escape('(').A(HA.href(BH.domain("selection").subsetItem(this.motcle).command("UserSelectionByMotcle").page(MainHtmlUtils.getMainPageName(this))).target("_blank")).__localize("_ link.selection.bymotcle")._A().__escape(')')._SPAN()._P();
        }
        return true;
    }

    private boolean printSatellite(MotcleStats motcleStats) {
        this.__(Tree.TREE, () -> {
            for (FicheMeta ficheMeta : motcleStats.getSatelliteList()) {
                String affichageHref = BdfInstructionUtils.getFicheGetLink(ficheMeta, "html");
                String ficheTitle = CorpusMetadataUtils.getFicheTitle(ficheMeta, this.workingLang, this.bdfUser.getFormatLocale());
                this.__(Tree.LEAF, () -> this.__escape(ficheTitle).__space().SPAN("global-SmallLinks").__escape('(').A(HA.href(BH.domain("edition").page("fiche-change").subsetItem(ficheMeta))).__localize("_ link.edition.fichechange_short")._A().__dash().A(HA.href(affichageHref)).__localize("_ link.global.display")._A().__escape(')')._SPAN());
            }
        });
        return true;
    }

    private static class MotcleStats {
        private List<FicheMeta> satelliteList;
        private int ficheCount = 0;

        private MotcleStats() {
        }

        private void addFicheCount(int ficheCount) {
            this.ficheCount += ficheCount;
        }

        private int getFicheCount() {
            return this.ficheCount;
        }

        private void addSatellite(FicheMeta ficheMeta) {
            if (this.satelliteList == null) {
                this.satelliteList = new ArrayList<FicheMeta>();
            }
            this.satelliteList.add(ficheMeta);
        }

        private List<FicheMeta> getSatelliteList() {
            return this.satelliteList;
        }

        private boolean hasSatellite() {
            return this.satelliteList != null;
        }
    }
}

