/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.sphere;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.BH;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;

public class SphereHtmlProducer
extends BdfServerHtmlProducer {
    private final PermissionSummary permissionSummary;
    private final Sphere sphere;
    private final SortedMap<String, Redacteur> activeMap = new TreeMap<String, Redacteur>();
    private final SortedMap<String, Redacteur> readonlyMap = new TreeMap<String, Redacteur>();
    private final SortedMap<String, Redacteur> inactiveMap = new TreeMap<String, Redacteur>();
    private final boolean isSubsetAdmin;
    private final Button linkButton = Button.link();
    private final PermissionManager permissionManager;

    public SphereHtmlProducer(BdfParameters bdfParameters, Sphere sphere) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.isSubsetAdmin = this.permissionSummary.isSubsetAdmin(sphere.getSubsetKey());
        this.sphere = sphere;
        this.permissionManager = bdfParameters.getBdfServer().getPermissionManager();
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addThemeCss("sphere.css");
        this.setBodyCssClass("global-body-ListFrame");
        this.initMaps();
    }

    @Override
    public void printHtml() {
        this.start(FichothequeUtils.getTitle(this.sphere, this.workingLang), true);
        this.__(BdfHtmlUtils.startSubsetUnit(this, this.bdfParameters, this.sphere, "sphere")).__(this.printCommands()).__(PageUnit.END).__(this.printMap(this.activeMap, "_ title.sphere.userlist_active", "sphere-Active")).__(this.printMap(this.readonlyMap, "_ title.sphere.userlist_readonly", "sphere-Readonly")).__(this.printMap(this.inactiveMap, "_ title.sphere.userlist_inactive", "sphere-Inactive"));
        this.end();
    }

    private boolean printCommands() {
        if (!this.isSubsetAdmin) {
            return false;
        }
        this.DETAILS(HA.id("details_commands").open(true).classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ title.global.commands")._SUMMARY().DIV("tools-List").__if(this.permissionSummary.isFichothequeAdmin(), this.link("action-New", "redacteur-creationform", "_ link.sphere.usercreationform")).__(this.link("action-Metadata", "sphere-metadataform", "_ link.sphere.spheremetadataform")).__(this.link("action-Advanced", "sphere-advancedcommands", "_ link.sphere.sphereadvancedcommands")).__(this.link("action-Refresh", "sphere", "_ link.global.reload")).__(Button.link("users/" + this.sphere.getSubsetName() + ".ods").action("action-Ods").textMessage("_ link.global.version", "ODS"))._DIV()._DETAILS();
        return true;
    }

    private Button link(String action, String page, String messageKey) {
        String href = BH.domain("sphere").subset(this.sphere).page(page).toString();
        String target = page.equals("sphere") ? null : "Edition";
        return this.linkButton.href(href).action(action).textL10nObject(messageKey).target(target);
    }

    private boolean printMap(Map<String, Redacteur> map, String titleKey, String cssClasses) {
        if (map.isEmpty()) {
            return false;
        }
        this.__(PageUnit.start().sectionCss("unit-Unit sphere-RedacteurListUnit " + cssClasses).title(() -> {
            this.SPAN("sphere-RedacteurListTitle").__localize(titleKey).__space().__(BdfHtmlUtils.printItemCount(this, this.bdfUser, map.size()))._SPAN();
            if (cssClasses.equals("sphere-Active") && this.permissionSummary.isFichothequeAdmin()) {
                this.__(Button.link().style("transparent").href(BH.domain("sphere").subset(this.sphere).page("redacteur-creationform")).action("action-New").tooltipMessage("_ link.sphere.usercreationform").target("Edition"));
            }
        })).UL("subsetitem-List").__(this.printRedacteurList(map))._UL().__(PageUnit.END);
        return true;
    }

    private boolean printRedacteurList(Map<String, Redacteur> map) {
        for (Map.Entry<String, Redacteur> entry : map.entrySet()) {
            this.LI().__(this.printRedacteur(entry.getKey(), entry.getValue()))._LI();
        }
        return true;
    }

    private boolean printRedacteur(String login, Redacteur redacteur) {
        boolean editable = this.permissionSummary.isFichothequeAdmin();
        this.DIV("subsetitem-Title").P().SPAN("sphere-Login").__escape(login)._SPAN().__dash().__escape(redacteur.getCompleteName()).__(this.printAdmin(redacteur))._P().__(this.printUserEdit(editable, redacteur))._DIV().__(this.printCommandDetails(editable, redacteur));
        return true;
    }

    private boolean printAdmin(Redacteur redacteur) {
        if (this.permissionManager.isAdmin(redacteur)) {
            this.__space().SPAN(HA.classes("sphere-Admin").title(this.getLocalization("_ label.sphere.admin"))).__escape("\ud83c\udd50")._SPAN();
            return true;
        }
        return false;
    }

    private boolean printUserEdit(boolean editable, Redacteur redacteur) {
        if (!editable) {
            return false;
        }
        this.A(HA.href(BH.domain("sphere").subsetItem(redacteur).page("redacteur-adminform")).target("Edition").classes("button-Circle action-UserEdit")).__(Button.ICON)._A();
        return true;
    }

    private boolean printCommandDetails(boolean editable, Redacteur redacteur) {
        if (!editable) {
            return false;
        }
        this.DETAILS("tools-Details").SUMMARY().__localize("_ title.global.commands")._SUMMARY().DIV("tools-List").__if(!redacteur.isInactive(), this.redacteurLink(redacteur, "action-Preferences", "redacteur-preferences", "_ link.sphere.userprefs")).__(this.redacteurLink(redacteur, "action-UserStats", "redacteur-stats", "_ link.sphere.userstats")).__(this.redacteurLink(redacteur, "action-Advanced", "redacteur-advancedcommands", "_ link.sphere.redacteuradvancedcommands"))._DIV()._DETAILS();
        return true;
    }

    private Button redacteurLink(Redacteur redacteur, String action, String page, String locKey) {
        String href = BH.domain("sphere").page(page).subsetItem(redacteur).toString();
        return this.linkButton.href(href).action(action).textL10nObject(locKey).target("Edition");
    }

    private void initMaps() {
        for (Redacteur redacteur : this.sphere.getRedacteurList()) {
            Map<String, Redacteur> map = this.getMap(redacteur);
            map.put(redacteur.getLogin(), redacteur);
        }
    }

    private Map<String, Redacteur> getMap(Redacteur redacteur) {
        switch (redacteur.getStatus()) {
            case "inactive": {
                return this.inactiveMap;
            }
            case "readonly": {
                return this.readonlyMap;
            }
        }
        return this.activeMap;
    }
}

