/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.pioche;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheArgs;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheParameters;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;

public class MotclePiocheHtmlProducer
extends BdfServerHtmlProducer {
    private final PiocheParameters piocheParameters;
    private final String wanted;

    public MotclePiocheHtmlProducer(BdfParameters bdfParameters, PiocheParameters piocheParameters) {
        super(bdfParameters);
        this.piocheParameters = piocheParameters;
        String wantedParam = (String)piocheParameters.getParameter("wanted");
        if (wantedParam != null) {
            switch (wantedParam) {
                case "id": 
                case "code-id": {
                    this.wanted = wantedParam;
                    break;
                }
                default: {
                    this.wanted = "code-title";
                    break;
                }
            }
        } else {
            this.wanted = "code-title";
        }
        this.addJsLib(MiscJsLibs.PIOCHE);
    }

    @Override
    public void printHtml() {
        List<Subset> thesaurusList = this.piocheParameters.getSubsetList();
        String clientId = this.generateId();
        String title = thesaurusList != null && thesaurusList.size() == 1 ? this.getLocalization("_ title.pioche.motcle_one", FichothequeUtils.getTitle(thesaurusList.get(0), this.workingLang)) : this.getLocalization("_ title.pioche.motcle");
        this.start(title);
        PiocheArgs piocheArgs = PiocheArgs.init().clientId(clientId).populate(this.piocheParameters).count(this.getTotal(thesaurusList)).separator(" \u2013 ").wanted(this.wanted).json("motcle").subsets(thesaurusList);
        this.__(piocheArgs).DIV(HA.id(clientId).classes("pioche-Client"))._DIV();
        this.end();
    }

    private int getTotal(List<Subset> thesaurusList) {
        int count = 0;
        if (thesaurusList == null) {
            for (Thesaurus thesaurus : this.fichotheque.getThesaurusList()) {
                count += thesaurus.size();
            }
        } else {
            for (Subset subset : thesaurusList) {
                count += subset.size();
            }
        }
        return count;
    }
}

