/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.instructions.tables.MultiTableExportEngine;
import fr.exemole.bdfserver.get.instructions.tables.UniqueTableExportEngine;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import java.text.ParseException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.ResponseHandlerFactory;
import net.mapeadores.util.text.FileName;

public class TablesInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final String filePath;
    private final RequestMap requestMap;

    public TablesInstruction(BdfServer bdfServer, String filePath, RequestMap requestMap) {
        this.bdfServer = bdfServer;
        this.filePath = filePath;
        this.requestMap = requestMap;
    }

    @Override
    public short getBdfUserNeed() {
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
        try {
            FileName fileName;
            if (this.filePath.equals("get-multi")) {
                MultiTableExportEngine multiTableExportEngine = MultiTableExportEngine.buildFromRequest(bdfParameters, this.requestMap);
                return multiTableExportEngine.run();
            }
            if (this.filePath.equals("get-htmlfragment")) {
                UniqueTableExportEngine uniqueTableExportEngine = UniqueTableExportEngine.buildFromRequest(bdfParameters, this.requestMap);
                return uniqueTableExportEngine.run();
            }
            try {
                fileName = FileName.parse(this.filePath);
            }
            catch (ParseException pe) {
                return null;
            }
            UniqueTableExportEngine uniqueTableExportEngine = UniqueTableExportEngine.buildFromPath(bdfParameters, fileName, this.requestMap);
            return uniqueTableExportEngine.run();
        }
        catch (ErrorMessageException eme) {
            return ResponseHandlerFactory.getHtmlInstance(bdfParameters.getMessageLocalisation(), eme.getErrorMessage());
        }
    }
}

