/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.conf;

import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.conf.WebappDirs;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.text.StringUtils;

public final class ConfUtils {
    private static final int BUFFER = 1024;
    private static final Set<String> RESERVED_WORDS = new HashSet<String>();
    private static final String VAR_PREFIX = "var/";

    private ConfUtils() {
    }

    public static boolean isValidMultiName(String s) {
        try {
            StringUtils.checkTechnicalName(s, true);
        }
        catch (ParseException pe) {
            return false;
        }
        return !ConfUtils.isReservedWord(s);
    }

    public static boolean isReservedWord(String s) {
        return RESERVED_WORDS.contains(s);
    }

    public static SortedSet<String> getExistingNameSet(WebappDirs webappDirs) {
        TreeSet<String> existingNameSet = new TreeSet<String>();
        File varDataRootDir = webappDirs.getDir("var.data");
        for (File file : varDataRootDir.listFiles()) {
            String name;
            if (!file.isDirectory() || !ConfUtils.isValidMultiName(name = file.getName())) continue;
            existingNameSet.add(name.intern());
        }
        return existingNameSet;
    }

    public static boolean isExistingName(WebappDirs webappDirs, String name) {
        if (!ConfUtils.isValidMultiName(name)) {
            return false;
        }
        File varDataRootDir = webappDirs.getDir("var.data");
        File existingDir = new File(varDataRootDir, name);
        return existingDir.exists() && existingDir.isDirectory();
    }

    public static File getMultiIniFile(WebappDirs webappDirs) {
        return new File(webappDirs.getDir("var.data"), "multi.ini");
    }

    public static void copyZippedFiles(BdfServerDirs dirs, File zipFile) throws IOException {
        try (ZipInputStream is = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry;
            while ((zipEntry = is.getNextEntry()) != null) {
                int idx;
                String name = zipEntry.getName();
                if (!name.startsWith(VAR_PREFIX) || (idx = name.indexOf(47, VAR_PREFIX.length())) == -1) continue;
                String subdirName = name.substring(VAR_PREFIX.length(), idx);
                String path = name.substring(idx + 1);
                File rootDir = dirs.getSubPath("var.data", subdirName);
                File destination = new File(rootDir, path);
                destination.getParentFile().mkdirs();
                ConfUtils.unzipFile(destination, is);
            }
        }
    }

    private static void unzipFile(File f, ZipInputStream zipStream) throws IOException {
        byte[] data = new byte[1024];
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f), 1024);){
            int count;
            while ((count = zipStream.read(data, 0, 1024)) != -1) {
                os.write(data, 0, count);
            }
        }
    }

    static {
        try (InputStream is = ConfUtils.class.getResourceAsStream("reserved-words.txt");){
            List<String> lines = IOUtils.readLines(is);
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                RESERVED_WORDS.add(line);
            }
        }
        catch (IOException ioe) {
            throw new InternalResourceException(ioe);
        }
    }
}

