/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.ExistingIdException;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.corpus.CorpusTools;
import net.fichotheque.tools.duplication.DuplicationUtils;
import net.fichotheque.tools.duplication.SubsetMatch;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.fichotheque.utils.EligibilityUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ThesaurusCloneCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ThesaurusClone";
    public static final String COMMANDKEY = "_ THS-15";
    public static String NEWTHESAURUS_PARAMNAME = "newthesaurus";
    public static String REINITID_PARAMNAME = "reinitid";
    public static String COPYCROISEMENTS_PARAMNAME = "copycroisements";
    public static String CLONESATELLITE_PARAMNAME = "clonesatellite";
    public static String SATELLITECORPUS_PARAMNAME = "satellitecorpus";
    public static String NEWCORPUS_PREFIX = "newcorpus|";
    public static String CLONEFICHES_PREFIX = "clonefiches|";
    private Thesaurus thesaurus;
    private SubsetKey newThesaurusKey;
    private boolean reinitId;
    private boolean copyCroisements;
    private boolean cloneSatellite;
    private final Map<SubsetKey, CorpusClone> corpusCloneMap = new TreeMap<SubsetKey, CorpusClone>();

    public ThesaurusCloneCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        ThesaurusEditor newThesaurusEditor = null;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            ThesaurusMetadata thesaurusMetadata = this.thesaurus.getThesaurusMetadata();
            try {
                newThesaurusEditor = fichothequeEditor.createThesaurus(this.newThesaurusKey, thesaurusMetadata.getThesaurusType());
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("test before ExistingSubsetException");
            }
            ThesaurusMetadataEditor newThesaurusMetadataEditor = newThesaurusEditor.getThesaurusMetadataEditor();
            Langs langs = thesaurusMetadata.getAuthorizedLangs();
            if (langs != null) {
                newThesaurusMetadataEditor.setAuthorizedLangs(langs);
            }
            FichothequeTools.copy(thesaurusMetadata, newThesaurusMetadataEditor, " (2)");
            SubsetMatch subsetMatch = new SubsetMatch(this.thesaurus, newThesaurusEditor.getThesaurus());
            for (Motcle motcle : this.thesaurus.getFirstLevelList()) {
                this.cloneMotcle(subsetMatch, fichothequeEditor, newThesaurusEditor, motcle, null);
            }
            if (this.cloneSatellite) {
                this.cloneSatelliteCorpus(subsetMatch, fichothequeEditor, session.getBdfServerEditor());
            }
            if (this.copyCroisements) {
                CroisementEditor croisementEditor = fichothequeEditor.getCroisementEditor();
                DuplicationUtils.copyCroisements(croisementEditor, subsetMatch, EligibilityUtils.exclude(this.thesaurus));
                DuplicationUtils.replicateLinks(croisementEditor, subsetMatch);
            }
        }
        this.putResultObject("obj.thesaurus", newThesaurusEditor.getThesaurus());
        this.setDone("_ done.thesaurus.thesaurusclone", this.thesaurus.getSubsetKeyString(), this.newThesaurusKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.reinitId = this.requestHandler.isTrue(REINITID_PARAMNAME);
        this.copyCroisements = this.requestHandler.isTrue(COPYCROISEMENTS_PARAMNAME);
        this.cloneSatellite = this.requestHandler.isTrue(CLONESATELLITE_PARAMNAME);
        String newThesaurusName = this.getMandatory(NEWTHESAURUS_PARAMNAME).trim();
        if (newThesaurusName.isEmpty()) {
            throw BdfErrors.error("_ error.empty.thesaurusname", newThesaurusName);
        }
        try {
            this.newThesaurusKey = SubsetKey.parse((short)2, newThesaurusName);
            if (this.fichotheque.containsSubset(this.newThesaurusKey)) {
                throw BdfErrors.error("_ error.existing.thesaurus", this.newThesaurusKey.getKeyString());
            }
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.thesaurusname", newThesaurusName);
        }
        if (this.cloneSatellite) {
            this.initSatelliteCorpus(this.requestHandler.getTokens(SATELLITECORPUS_PARAMNAME));
        }
    }

    private void initSatelliteCorpus(String[] values) throws ErrorMessageException {
        if (values.length == 0) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        for (String value : values) {
            set.add(value);
        }
        for (Corpus corpus : this.thesaurus.getSatelliteCorpusList()) {
            SubsetKey newCorpusKey;
            String corpusName = corpus.getSubsetName();
            if (!set.contains(corpusName)) continue;
            String newCorpusName = this.getMandatory(NEWCORPUS_PREFIX + corpusName).trim();
            if (newCorpusName.length() == 0) {
                throw BdfErrors.error("_ error.empty.corpusname", newCorpusName);
            }
            try {
                newCorpusKey = SubsetKey.parse((short)1, newCorpusName);
                if (this.fichotheque.containsSubset(newCorpusKey)) {
                    throw BdfErrors.error("_ error.existing.corpus", newCorpusKey.getKeyString());
                }
            }
            catch (ParseException pe) {
                throw BdfErrors.error("_ error.wrong.corpusname", newCorpusName);
            }
            if (this.corpusCloneMap.containsKey(newCorpusKey)) {
                throw BdfErrors.error("_ error.existing.corpus", newCorpusKey.getKeyString());
            }
            boolean cloneFiches = this.requestHandler.isTrue(CLONEFICHES_PREFIX + corpusName);
            this.corpusCloneMap.put(newCorpusKey, new CorpusClone(corpus, newCorpusKey, cloneFiches));
        }
    }

    private void cloneMotcle(SubsetMatch subsetMatch, FichothequeEditor fichothequeEditor, ThesaurusEditor newThesaurusEditor, Motcle motcle, Motcle parentMotcle) {
        int id = this.reinitId ? -1 : motcle.getId();
        Motcle newMotcle = null;
        try {
            newMotcle = newThesaurusEditor.createMotcle(id, motcle.getIdalpha());
        }
        catch (ParseException | ExistingIdException e) {
            throw new ShouldNotOccurException("clone motcle");
        }
        if (parentMotcle != null) {
            try {
                newThesaurusEditor.setParent(newMotcle, parentMotcle);
            }
            catch (ParentRecursivityException pre) {
                throw new ShouldNotOccurException("clone motcle");
            }
        }
        ThesaurusTools.copy(newThesaurusEditor, motcle, newMotcle);
        subsetMatch.add(motcle, newMotcle);
        for (Motcle child : motcle.getChildList()) {
            this.cloneMotcle(subsetMatch, fichothequeEditor, newThesaurusEditor, child, newMotcle);
        }
    }

    private void cloneSatelliteCorpus(SubsetMatch masterSubsetMatch, FichothequeEditor fichothequeEditor, BdfServerEditor bdfServerEditor) {
        if (this.corpusCloneMap.isEmpty()) {
            return;
        }
        Subset masterSubset = masterSubsetMatch.getDestinationSubset();
        CroisementEditor croisementEditor = fichothequeEditor.getCroisementEditor();
        for (CorpusClone corpusClone : this.corpusCloneMap.values()) {
            CorpusEditor destinationEditor;
            Corpus origin = corpusClone.origin;
            try {
                destinationEditor = fichothequeEditor.createCorpus(corpusClone.destinationCorpusKey, masterSubset);
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("test before ExistingSubsetException");
            }
            CorpusTools.copy(origin.getCorpusMetadata(), destinationEditor.getCorpusMetadataEditor());
            UiUtils.copyUi(bdfServerEditor, origin, destinationEditor.getCorpus());
            if (!corpusClone.cloneFiches) continue;
            SubsetMatch ficheMatch = new SubsetMatch(origin, destinationEditor.getCorpus());
            for (FicheMeta originFiche : origin.getFicheMetaList()) {
                FicheMeta destinationFiche = null;
                SubsetMatch.Entry masterEntry = masterSubsetMatch.getEntryByOrigin(originFiche.getId());
                try {
                    destinationFiche = destinationEditor.createFiche(masterEntry.getDestination().getId());
                }
                catch (ExistingIdException eie) {
                    throw new ShouldNotOccurException("ExistingId test done before");
                }
                catch (NoMasterIdException eie) {
                    throw new ShouldNotOccurException("NoMasterId test done before");
                }
                CorpusTools.copy(destinationEditor, originFiche, destinationFiche, originFiche.getFicheAPI(true));
                ficheMatch.add(originFiche, destinationFiche);
            }
            if (!this.copyCroisements) continue;
            DuplicationUtils.copyCroisements(croisementEditor, ficheMatch, EligibilityUtils.exclude(origin));
            DuplicationUtils.replicateLinks(croisementEditor, ficheMatch);
        }
    }

    private static class CorpusClone {
        private final Corpus origin;
        private final SubsetKey destinationCorpusKey;
        private final boolean cloneFiches;

        private CorpusClone(Corpus origin, SubsetKey destinationCorpusKey, boolean cloneFiches) {
            this.origin = origin;
            this.destinationCorpusKey = destinationCorpusKey;
            this.cloneFiches = cloneFiches;
        }
    }
}

