/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class BalayageContentChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "BalayageContentChange";
    public static final String COMMANDKEY = "_ EXP-56";
    public static final String CONTENT_PARAMNAME = "content";
    private String balayageName;
    private String contentPath;
    private String content;

    public BalayageContentChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        BalayageDescription balayageDescription;
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        try (InputStream is = IOUtils.toInputStream(this.content, "UTF-8");){
            balayageDescription = this.bdfServer.getBalayageManager().putBalayageContent(this.balayageName, this.contentPath, is, editOrigin);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.balayagecontent_io", ioe.getMessage());
        }
        if (balayageDescription != null) {
            this.putResultObject("obj.templatedescription", balayageDescription);
            this.setDone("_ done.exportation.balayagecontentchange", this.balayageName, this.contentPath);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        BalayageDescription balayageDescription = this.requestHandler.getMandatoryBalayageDescription();
        this.balayageName = balayageDescription.getName();
        this.contentPath = this.requestHandler.getMandatoryPath();
        this.content = this.getMandatory(CONTENT_PARAMNAME);
    }
}

