/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.commands.AbstractPhrasesCommand;
import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.parsers.TypoParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.TypoOptions;

public class CorpusPhrasesCommand
extends AbstractPhrasesCommand {
    public static final String COMMANDNAME = "CorpusPhrases";
    public static final String COMMANDKEY = "_ CRP-10";
    private Corpus corpus;

    public CorpusPhrasesCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            CorpusMetadataEditor corpusMetadataEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus).getCorpusMetadataEditor();
            done = this.update(corpusMetadataEditor);
            for (String paramName : this.requestHandler.getParameterNameSet()) {
                int idx = paramName.lastIndexOf(47);
                if (idx == -1) continue;
                String fieldName = paramName.substring(0, idx);
                try {
                    boolean stepDone;
                    Lang currentLang = Lang.parse(paramName.substring(idx + 1));
                    FieldKey fieldKey = FieldKey.parse(fieldName);
                    TypoOptions typoOptions = TypoOptions.getTypoOptions(currentLang.toLocale());
                    String newLabelString = TypoParser.parseTypo(this.requestHandler.getMandatoryParameter(paramName), typoOptions);
                    CleanedString cleanedString = CleanedString.newInstance(newLabelString);
                    CorpusField corpusField = this.corpus.getCorpusMetadata().getCorpusField(fieldKey);
                    if (corpusField == null || !(stepDone = cleanedString == null ? corpusMetadataEditor.removeFieldLabel(corpusField, currentLang) : corpusMetadataEditor.putFieldLabel(corpusField, LabelUtils.toLabel(currentLang, cleanedString)))) continue;
                    done = true;
                }
                catch (ParseException parseException) {}
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.corpusphrases", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.checkPhrasesParameters();
    }
}

