/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class DateFormatBundle {
    private static final Map<Locale, DateFormatBundle> cacheMap = new HashMap<Locale, DateFormatBundle>();
    public static final String S1_KEy = "s1";
    public static final String S2_KEy = "s2";
    public static final String T1_KEy = "t1";
    public static final String T2_KEy = "t2";
    public static final String T3_KEy = "t3";
    public static final String T4_KEy = "t4";
    private final DateFormat datejour;
    private final DateFormat datemois;
    private final DateFormat dateannee;
    private final DateFormat parserdate;
    private final ResourceBundle dateBundle;

    private DateFormatBundle(Locale locale) {
        this.parserdate = DateFormat.getDateInstance(3, locale);
        this.datejour = DateFormat.getDateInstance(1, locale);
        this.datemois = new SimpleDateFormat("MMMM yyyy", locale);
        this.dateannee = new SimpleDateFormat("yyyy", locale);
        this.dateBundle = ResourceBundle.getBundle("net.mapeadores.util.text.resources.DateResourceBundle", locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateFormatBundle getDateFormatBundle(Locale locale) {
        DateFormatBundle dateFormatBundle = cacheMap.get(locale);
        if (dateFormatBundle == null) {
            Map<Locale, DateFormatBundle> map = cacheMap;
            synchronized (map) {
                dateFormatBundle = new DateFormatBundle(locale);
                cacheMap.put(locale, dateFormatBundle);
            }
        }
        return dateFormatBundle;
    }

    public DateFormat getFormatAnnee() {
        return this.dateannee;
    }

    public DateFormat getFormatJour() {
        return this.datejour;
    }

    public DateFormat getFormatMois() {
        return this.datemois;
    }

    public DateFormat getParseFormat() {
        return this.parserdate;
    }

    public String getLocalizedString(String key) {
        return this.dateBundle.getString(key);
    }
}

