/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets.handlers;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.xml.XmlProducer;

public class XmlResponseHandler
implements ResponseHandler {
    private final XmlProducer xmlProducer;
    private final String contentType;
    private long lastModified = -1L;

    public XmlResponseHandler(XmlProducer xmlProducer) {
        this.xmlProducer = xmlProducer;
        this.contentType = "text/xml";
    }

    public XmlResponseHandler(XmlProducer xmlProducer, String contentType) {
        this.xmlProducer = xmlProducer;
        this.contentType = contentType;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    public XmlResponseHandler lastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Override
    public void handleResponse(HttpServletResponse response) throws IOException {
        response.setContentType(this.contentType + ";charset=UTF-8");
        try (PrintWriter pw = response.getWriter();){
            this.xmlProducer.writeXml(pw);
        }
    }

    public static XmlResponseHandler init(XmlProducer xmlProducer) {
        return new XmlResponseHandler(xmlProducer);
    }

    public static XmlResponseHandler init(XmlProducer xmlProducer, String contentType) {
        return new XmlResponseHandler(xmlProducer, contentType);
    }
}

