/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.text.ParseException;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import net.mapeadores.util.primitives.DateFilter;
import net.mapeadores.util.primitives.DateFilterFactory;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.primitives.RangeDateFilter;
import net.mapeadores.util.text.StringUtils;

public final class DateFilterUtils {
    public static final DateFilter NULL_FILTER = new NullDateFilter(true);
    public static final DateFilter NOTNULL_FILTER = new NullDateFilter(false);

    private DateFilterUtils() {
    }

    public static RangeDateFilter parseDateFilter(String s) throws ParseException {
        String[] tokens = StringUtils.getTechnicalTokens(s, false);
        int length = tokens.length;
        if (length == 0) {
            return null;
        }
        if (length > 2) {
            throw new ParseException("Too many tokens", s.length() - 1);
        }
        if (length == 1) {
            FuzzyDate date = FuzzyDate.parse(tokens[0]);
            return DateFilterFactory.newInstance(date);
        }
        FuzzyDate date1 = FuzzyDate.parse(tokens[0]);
        FuzzyDate date2 = FuzzyDate.parse(tokens[1]);
        return DateFilterFactory.newInstance(date1, date2);
    }

    public static String toString(DateFilter dateFilter) {
        if (dateFilter instanceof RangeDateFilter) {
            FuzzyDate max;
            RangeDateFilter rangeDateFilter = (RangeDateFilter)dateFilter;
            FuzzyDate min = rangeDateFilter.getMinDate();
            if (min.equals(max = rangeDateFilter.getMaxDate())) {
                return min.toString();
            }
            return min.toString() + " ; " + max.toString();
        }
        return "";
    }

    public static boolean intersects(FuzzyDate date, DateFilter dateFilter) {
        if (dateFilter.containsDate(date)) {
            return true;
        }
        if (!(dateFilter instanceof RangeDateFilter)) {
            return false;
        }
        if (date == null) {
            return false;
        }
        return DateFilterUtils.intersects((RangeDateFilter)dateFilter, (DateFilter)DateFilterFactory.newInstance(date));
    }

    public static boolean intersects(FuzzyDate date1, FuzzyDate date2, DateFilter dateFilter) {
        if (dateFilter.containsDate(date1)) {
            return true;
        }
        if (dateFilter.containsDate(date2)) {
            return true;
        }
        if (!(dateFilter instanceof RangeDateFilter)) {
            return false;
        }
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return false;
        }
        return DateFilterUtils.intersects((RangeDateFilter)dateFilter, (DateFilter)DateFilterFactory.newInstance(date1, date2));
    }

    public static List<DateFilter> wrap(DateFilter[] array) {
        return new DateFilterList(array);
    }

    private static boolean intersects(RangeDateFilter rangeDateFilter, DateFilter otherFilter) {
        FuzzyDate max;
        FuzzyDate min = rangeDateFilter.getMinDate();
        if (min.equals(max = rangeDateFilter.getMaxDate())) {
            return otherFilter.containsDate(min);
        }
        return otherFilter.containsDate(min) || otherFilter.containsDate(max);
    }

    private static class DateFilterList
    extends AbstractList<DateFilter>
    implements RandomAccess {
        private final DateFilter[] array;

        private DateFilterList(DateFilter[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public DateFilter get(int index) {
            return this.array[index];
        }
    }

    private static class NullDateFilter
    implements DateFilter {
        private final boolean isNull;

        private NullDateFilter(boolean isNull) {
            this.isNull = isNull;
        }

        @Override
        public boolean containsDate(FuzzyDate date) {
            if (date == null) {
                return this.isNull;
            }
            return !this.isNull;
        }
    }
}

