/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.mimetype;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.mimetype.MimeTypeConstants;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeResolverBuilder;

public final class MimeTypeUtils
implements MimeTypeConstants {
    public static final MimeTypeResolver DEFAULT_RESOLVER = MimeTypeUtils.initDefault();

    private MimeTypeUtils() {
    }

    public static String getMimeType(MimeTypeResolver mimeTypeResolver, String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (idx == -1) {
            return "application/octet-stream";
        }
        String extension = fileName.substring(idx + 1);
        return mimeTypeResolver.getMimeType(extension);
    }

    public static String getDefaultCharset(String mimeType) {
        if (mimeType.startsWith("text/")) {
            return "UTF-8";
        }
        if (mimeType.contains("xml")) {
            return "UTF-8";
        }
        if (mimeType.equals("application/javascript")) {
            return "UTF-8";
        }
        if (mimeType.equals("application/json")) {
            return "UTF-8";
        }
        return null;
    }

    private static MimeTypeResolver initDefault() {
        InputStreamReader reader;
        MimeTypeResolverBuilder builder = new MimeTypeResolverBuilder();
        try {
            reader = new InputStreamReader(MimeTypeUtils.class.getResourceAsStream("utillib-list.txt"), "UTF-8");
            try {
                builder.parse(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException ioe) {
            throw new InternalResourceException(ioe);
        }
        try {
            reader = new InputStreamReader(MimeTypeUtils.class.getResourceAsStream("debian-list.txt"), "UTF-8");
            try {
                builder.parse(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException ioe) {
            throw new InternalResourceException(ioe);
        }
        return builder.toMimeTypeResolver();
    }
}

