/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;
import net.mapeadores.util.io.StreamProducer;

public abstract class ZipStreamProducer
implements StreamProducer {
    private final String fileName;

    public ZipStreamProducer() {
        this.fileName = null;
    }

    public ZipStreamProducer(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getMimeType() {
        return "application/zip";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        try (ZipOutputStream os = new ZipOutputStream(outputStream);){
            this.writeZipStream(os);
        }
    }

    public abstract void writeZipStream(ZipOutputStream var1) throws IOException;
}

