/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.http;

import java.io.IOException;
import net.mapeadores.util.http.RedirectionUrl;
import net.mapeadores.util.http.UrlStatus;
import net.mapeadores.util.http.UrlStatusUtils;
import net.mapeadores.util.primitives.io.PrimitivesReader;
import net.mapeadores.util.primitives.io.PrimitivesWriter;

public final class UrlStatusPrimitives {
    private UrlStatusPrimitives() {
    }

    public static void writeUrlStatus(UrlStatus urlStatus, PrimitivesWriter primitivesWriter) throws IOException {
        String state = urlStatus.getState();
        int specialCode = UrlStatusUtils.getSpecialCode(state);
        primitivesWriter.writeInt(specialCode);
        if (specialCode == 0) {
            primitivesWriter.writeString(state);
            int responseCode = urlStatus.getResponseCode();
            primitivesWriter.writeInt(responseCode);
            if (responseCode > 0) {
                primitivesWriter.writeString(urlStatus.getResponseMessage());
                RedirectionUrl redirectionUrl = urlStatus.getRedirectionUrl();
                if (redirectionUrl == null) {
                    primitivesWriter.writeBoolean(false);
                } else {
                    primitivesWriter.writeBoolean(true);
                    UrlStatusPrimitives.writeRedirectionUrl(redirectionUrl, primitivesWriter);
                }
            }
        }
    }

    public static void writeRedirectionUrl(RedirectionUrl redirectionUrl, PrimitivesWriter primitivesWriter) throws IOException {
        primitivesWriter.writeString(redirectionUrl.getUrl());
        UrlStatusPrimitives.writeUrlStatus(redirectionUrl.getUrlStatus(), primitivesWriter);
    }

    public static UrlStatus readUrlStatus(PrimitivesReader primitivesReader) throws IOException {
        int specialCode = primitivesReader.readInt();
        UrlStatus specialUrlStatus = UrlStatusUtils.getSpecial(specialCode);
        if (specialUrlStatus != null) {
            return specialUrlStatus;
        }
        String state = primitivesReader.readString();
        state = UrlStatusUtils.checkState(state);
        int responseCode = primitivesReader.readInt();
        if (responseCode > 0) {
            String responseMessage = primitivesReader.readString();
            boolean withRedirection = primitivesReader.readBoolean();
            RedirectionUrl redirectionUrl = null;
            if (withRedirection) {
                redirectionUrl = UrlStatusPrimitives.readRedirectionUrl(primitivesReader);
            }
            return new UrlStatus(state, responseCode, responseMessage, redirectionUrl);
        }
        return new UrlStatus(state);
    }

    public static RedirectionUrl readRedirectionUrl(PrimitivesReader primitivesReader) throws IOException {
        String url = primitivesReader.readString();
        UrlStatus urlStatus = UrlStatusPrimitives.readUrlStatus(primitivesReader);
        return new RedirectionUrl(url, urlStatus);
    }
}

