/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.attr;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuffer;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.CleanedString;

public class AttributeChangeBuilder
implements AttributeBuffer {
    private final SortedMap<AttributeKey, AttributeBuilder> attributeBuilderMap = new TreeMap<AttributeKey, AttributeBuilder>();
    private final Set<AttributeKey> removedKeySet = new LinkedHashSet<AttributeKey>();

    public boolean containsValue(AttributeKey attributeKey) {
        AttributeBuilder builder = (AttributeBuilder)this.attributeBuilderMap.get(attributeKey);
        if (builder == null) {
            return false;
        }
        return !builder.isEmpty();
    }

    @Override
    public AttributeChangeBuilder appendValue(AttributeKey attributeKey, String value) {
        return (AttributeChangeBuilder)AttributeBuffer.super.appendValue(attributeKey, value);
    }

    @Override
    public AttributeChangeBuilder appendValue(AttributeKey attributeKey, CleanedString cleanedString) {
        if (cleanedString == null) {
            return this;
        }
        AttributeBuilder builder = (AttributeBuilder)this.attributeBuilderMap.get(attributeKey);
        if (builder == null) {
            builder = new AttributeBuilder(attributeKey);
            this.attributeBuilderMap.put(attributeKey, builder);
        }
        builder.addValue(cleanedString);
        return this;
    }

    public AttributeChangeBuilder appendValues(AttributeKey attributeKey, List<CleanedString> valueList) {
        if (valueList.isEmpty()) {
            return this;
        }
        AttributeBuilder builder = (AttributeBuilder)this.attributeBuilderMap.get(attributeKey);
        if (builder == null) {
            builder = new AttributeBuilder(attributeKey);
            this.attributeBuilderMap.put(attributeKey, builder);
        }
        for (CleanedString cs : valueList) {
            if (cs == null) continue;
            builder.addValue(cs);
        }
        return this;
    }

    public AttributeChangeBuilder appendValues(Attribute attribute) {
        return this.appendValues(attribute.getAttributeKey(), attribute);
    }

    public AttributeChangeBuilder appendValues(AttributeKey attributeKey, Attribute attribute) {
        AttributeBuilder builder = (AttributeBuilder)this.attributeBuilderMap.get(attributeKey);
        if (builder == null) {
            builder = new AttributeBuilder(attributeKey);
            this.attributeBuilderMap.put(attributeKey, builder);
        }
        int valueLength = attribute.size();
        for (int i = 0; i < valueLength; ++i) {
            builder.addValue(CleanedString.newInstance((CharSequence)attribute.get(i)));
        }
        return this;
    }

    public AttributeChangeBuilder clearAttribute(AttributeKey attributeKey) {
        this.attributeBuilderMap.remove(attributeKey);
        return this;
    }

    public AttributeChangeBuilder changeAttributes(AttributeChange attributeChange) {
        for (Attribute attribute : attributeChange.getChangedAttributes()) {
            this.put(attribute);
        }
        for (AttributeKey removedAttributeKey : attributeChange.getRemovedAttributeKeyList()) {
            this.attributeBuilderMap.remove(removedAttributeKey);
        }
        return this;
    }

    public void putRemovedAttributeKey(AttributeKey attributeKey) {
        this.removedKeySet.add(attributeKey);
    }

    public AttributeChangeBuilder merge(AttributeChangeBuilder otherAttributeChangeBuilder) {
        for (AttributeKey otherAttributeKey : otherAttributeChangeBuilder.removedKeySet) {
            this.removedKeySet.add(otherAttributeKey);
        }
        for (AttributeBuilder otherAttributeBuilder : otherAttributeChangeBuilder.attributeBuilderMap.values()) {
            this.appendValues(otherAttributeBuilder.toAttribute());
        }
        return this;
    }

    public AttributeChangeBuilder filterRealChanges(Attributes attributes, AttributeChange attributeChange, Predicate<AttributeKey> removeableAttributePredicate) {
        for (Attribute changedAttribute : attributeChange.getChangedAttributes()) {
            Attribute currentAttribute = attributes.getAttribute(changedAttribute.getAttributeKey());
            if (currentAttribute != null && AttributeUtils.isEqual(currentAttribute, changedAttribute)) continue;
            this.put(changedAttribute);
        }
        for (AttributeKey attributeKey : attributeChange.getRemovedAttributeKeyList()) {
            if (attributes.getAttribute(attributeKey) == null) continue;
            this.putRemovedAttributeKey(attributeKey);
        }
        for (Attribute attribute : attributes) {
            AttributeKey attributeKey = attribute.getAttributeKey();
            if (!removeableAttributePredicate.test(attributeKey) || attributeChange.getChangedAttributes().getAttribute(attributeKey) != null) continue;
            this.putRemovedAttributeKey(attributeKey);
        }
        return this;
    }

    public Attributes toAttributes(@Nullable Attributes previousAttributes) {
        if (previousAttributes == null) {
            previousAttributes = AttributeUtils.EMPTY_ATTRIBUTES;
        }
        if (this.attributeBuilderMap.isEmpty() && this.removedKeySet.isEmpty()) {
            return previousAttributes;
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (Attribute attribute : previousAttributes) {
            AttributeKey attributeKey = attribute.getAttributeKey();
            if (this.attributeBuilderMap.containsKey(attributeKey) || this.removedKeySet.contains(attributeKey)) continue;
            attributeList.add(attribute);
        }
        for (AttributeBuilder builder : this.attributeBuilderMap.values()) {
            Attribute attribute = builder.toAttribute();
            if (attribute == null) continue;
            attributeList.add(attribute);
        }
        int size = attributeList.size();
        if (size == 0) {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
        if (size == 1) {
            return AttributeUtils.toSingletonAttributes((Attribute)attributeList.get(0));
        }
        Attribute[] array = attributeList.toArray(new Attribute[size]);
        return new InternalAttributes(array);
    }

    public AttributeChange toAttributeChange() {
        Attributes changedAttributes = this.toAttributes(null);
        for (AttributeKey attributeKey : this.attributeBuilderMap.keySet()) {
            this.removedKeySet.remove(attributeKey);
        }
        List<AttributeKey> removedAttributeKeyList = this.removedKeySet.isEmpty() ? AttributeUtils.EMPTY_ATTRIBUTEKEYLIST : AttributeUtils.wrap(this.removedKeySet.toArray(new AttributeKey[this.removedKeySet.size()]));
        return new InternalChangeAttribute(changedAttributes, removedAttributeKeyList);
    }

    private void put(Attribute attribute) {
        AttributeKey attributeKey = attribute.getAttributeKey();
        AttributeBuilder builder = new AttributeBuilder(attributeKey);
        for (String value : attribute) {
            builder.addValue(CleanedString.newInstance(value));
        }
        this.attributeBuilderMap.put(attributeKey, builder);
    }

    public static AttributeChangeBuilder init() {
        return new AttributeChangeBuilder();
    }

    private static class InternalAttributes
    extends AbstractList<Attribute>
    implements Attributes {
        private final Attribute[] attributeArray;

        private InternalAttributes(Attribute[] attributeArray) {
            this.attributeArray = attributeArray;
        }

        @Override
        public Attribute getAttribute(AttributeKey key) {
            for (Attribute attribute : this.attributeArray) {
                if (!attribute.getAttributeKey().equals(key)) continue;
                return attribute;
            }
            return null;
        }

        @Override
        public int size() {
            return this.attributeArray.length;
        }

        @Override
        public Attribute get(int i) {
            return this.attributeArray[i];
        }
    }

    private static class InternalChangeAttribute
    implements AttributeChange {
        private final Attributes changedAttributes;
        private final List<AttributeKey> removedAttributeKeyList;

        private InternalChangeAttribute(Attributes changedAttributes, List<AttributeKey> removedAttributeKeyList) {
            this.changedAttributes = changedAttributes;
            this.removedAttributeKeyList = removedAttributeKeyList;
        }

        @Override
        public Attributes getChangedAttributes() {
            return this.changedAttributes;
        }

        @Override
        public List<AttributeKey> getRemovedAttributeKeyList() {
            return this.removedAttributeKeyList;
        }
    }
}

