/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.elements;

import java.util.HashMap;
import java.util.Map;
import net.mapeadores.opendocument.elements.OdElement;
import net.mapeadores.opendocument.elements.OdElementUtils;

public class StyleElement
extends OdElement {
    public static final String PARAGRAPH_FAMILY = "paragraph";
    public static final String TEXT_FAMILY = "text";
    public static final String TABLE_FAMILY = "table";
    public static final String TABLECELL_FAMILY = "table-cell";
    public static final String TABLEROW_FAMILY = "table-row";
    public static final String TABLECOLUMN_FAMILY = "table-column";
    public static final String GRAPHIC_FAMILY = "graphic";
    private static final Map<String, int[]> availableMap = new HashMap<String, int[]>();
    private final String styleFamily;
    private final int[] availableTypeArray;
    private final String styleName;

    private StyleElement(String styleFamily, String styleName, int[] availableTypeArray) {
        this.styleFamily = styleFamily;
        this.availableTypeArray = availableTypeArray;
        this.styleName = styleName;
    }

    public String getStyleName() {
        return this.styleName;
    }

    @Override
    public int[] getAvalaibleTypeArray() {
        return this.availableTypeArray;
    }

    public String getStyleFamily() {
        return this.styleFamily;
    }

    public static StyleElement newInstance(String styleFamily, String styleName) {
        String displayName = OdElementUtils.toDisplayNameValue(styleName);
        styleName = OdElementUtils.checkStyleNameValue(styleName);
        int[] result = availableMap.get(styleFamily);
        StyleElement styleElement = new StyleElement(styleFamily, styleName, result);
        styleElement.putAttribute("display-name", displayName);
        return styleElement;
    }

    public static StyleElement newHInstance(int level) {
        String levelString = String.valueOf(level);
        String styleName = "Heading_20_" + levelString;
        int[] result = new int[]{1, 3, 2};
        StyleElement styleElement = new StyleElement(PARAGRAPH_FAMILY, styleName, result);
        styleElement.putAttribute("default-outline-level", levelString).putAttribute("parent-style-name", "Heading").putAttribute("display-name", "Heading " + levelString);
        return styleElement;
    }

    public static String getMatchingStyleFamily(String elementName) {
        switch (elementName) {
            case "p": {
                return PARAGRAPH_FAMILY;
            }
            case "span": {
                return TEXT_FAMILY;
            }
            case "table": {
                return TABLE_FAMILY;
            }
            case "col": 
            case "column": {
                return TABLECOLUMN_FAMILY;
            }
            case "td": 
            case "cell": {
                return TABLECELL_FAMILY;
            }
            case "tr": 
            case "row": {
                return TABLEROW_FAMILY;
            }
            case "graphic": {
                return GRAPHIC_FAMILY;
            }
        }
        return null;
    }

    static {
        int[] avprg = new int[]{1, 3, 2};
        availableMap.put(PARAGRAPH_FAMILY, avprg);
        int[] avtxt = new int[]{1, 2};
        availableMap.put(TEXT_FAMILY, avtxt);
        int[] avtb = new int[]{1, 5};
        availableMap.put(TABLE_FAMILY, avtb);
        int[] avtd = new int[]{1, 8, 3, 2};
        availableMap.put(TABLECELL_FAMILY, avtd);
        int[] avtr = new int[]{1, 9};
        availableMap.put(TABLEROW_FAMILY, avtr);
        int[] avcol = new int[]{1, 7};
        availableMap.put(TABLECOLUMN_FAMILY, avcol);
        int[] avgraph = new int[]{1, 12};
        availableMap.put(GRAPHIC_FAMILY, avgraph);
    }
}

