/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.elements;

public final class OdElementUtils {
    private OdElementUtils() {
    }

    public static String toDisplayNameValue(String styleNameValue) {
        StringBuilder displayBuf = new StringBuilder();
        int length = styleNameValue.length();
        char previous = styleNameValue.charAt(0);
        displayBuf.append(previous);
        for (int i = 1; i < length; ++i) {
            char carac = styleNameValue.charAt(i);
            if (carac == '_') {
                displayBuf.append(" ");
                continue;
            }
            displayBuf.append(carac);
        }
        return displayBuf.toString();
    }

    public static String checkStyleNameValue(String styleNameValue) {
        int hLevel = OdElementUtils.getHLevel(styleNameValue);
        if (hLevel == 0) {
            return "Heading";
        }
        if (hLevel > 0) {
            return "Heading_20_" + String.valueOf(hLevel);
        }
        int length = styleNameValue.length();
        if (length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char carac = styleNameValue.charAt(i);
            if (carac == '_') {
                buf.append("_20_");
                continue;
            }
            buf.append(carac);
        }
        return buf.toString();
    }

    public static boolean charTest(char carac) {
        if (carac >= '0' && carac <= '9') {
            return true;
        }
        return Character.isUpperCase(carac);
    }

    public static int getHLevel(String value) {
        if (!value.startsWith("h")) {
            return -1;
        }
        int length = value.length();
        if (length == 1) {
            return 0;
        }
        try {
            int level = Integer.parseInt(value.substring(1));
            if (level < 1) {
                return -2;
            }
            if (level > 10) {
                return -3;
            }
            return level;
        }
        catch (NumberFormatException nfe) {
            return -4;
        }
    }

    public static boolean isStyleNameAttribute(String attributeName) {
        switch (attributeName) {
            case "parent-style-name": 
            case "next-style-name": 
            case "style-name": 
            case "list-style-name": 
            case "master-page-name": {
                return true;
            }
        }
        return false;
    }
}

