/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.importation;

import java.io.IOException;
import net.fichotheque.importation.ParentChange;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.xml.importation.LiensImportXMLPart;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class ThesaurusImportXMLPart
extends XMLPart {
    private final LiensImportXMLPart liensImportXMLPart;

    public ThesaurusImportXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
        this.liensImportXMLPart = new LiensImportXMLPart(xmlWriter);
    }

    public void addThesaurusImport(ThesaurusImport thesaurusImport) throws IOException {
        String type = thesaurusImport.getType();
        this.startOpenTag("thesaurusimport");
        this.addAttribute("thesaurus", thesaurusImport.getThesaurus().getSubsetName());
        this.addAttribute("type", type);
        Thesaurus destinationThesaurus = thesaurusImport.getDestinationThesaurus();
        if (destinationThesaurus != null) {
            this.addAttribute("destination", destinationThesaurus.getSubsetName());
        }
        this.endOpenTag();
        for (ThesaurusImport.MotcleImport motcleImport : thesaurusImport.getMotcleImportList()) {
            if (motcleImport instanceof ThesaurusImport.EditMotcleImport) {
                this.addEditMotcleImport((ThesaurusImport.EditMotcleImport)motcleImport);
                continue;
            }
            if (motcleImport instanceof ThesaurusImport.MergeMotcleImport) {
                this.addMergeMotcleImport((ThesaurusImport.MergeMotcleImport)motcleImport);
                continue;
            }
            this.addMotcleImport(motcleImport);
        }
        this.closeTag("thesaurusimport");
    }

    private void addMotcleImport(ThesaurusImport.MotcleImport motcleImport) throws IOException {
        this.startOpenTag("motcleimport");
        this.addAttribute("id", motcleImport.getMotcleId());
        this.closeEmptyTag();
    }

    private void addEditMotcleImport(ThesaurusImport.EditMotcleImport motcleImport) throws IOException {
        ParentChange parentChange;
        String newStatus;
        this.startOpenTag("motcleimport");
        int id = motcleImport.getMotcleId();
        if (id > 0) {
            this.addAttribute("id", id);
        }
        this.endOpenTag();
        String newIdalpha = motcleImport.getNewIdalpha();
        if (newIdalpha != null) {
            this.addSimpleElement("idalpha", newIdalpha);
        }
        if ((newStatus = motcleImport.getNewStatus()) != null) {
            this.addSimpleElement("status", newStatus);
        }
        if ((parentChange = motcleImport.getParentChange()) != null) {
            this.startOpenTag("parent");
            if (parentChange instanceof ParentChange.Id) {
                this.addAttribute("id", ((ParentChange.Id)parentChange).getParentId());
            } else if (parentChange instanceof ParentChange.Idalpha) {
                this.addAttribute("idalpha", ((ParentChange.Idalpha)parentChange).getParentIdalpha());
            }
            this.closeEmptyTag();
        }
        this.addLabelChange(motcleImport.getLabelChange());
        this.addAttributeChange(motcleImport.getAttributeChange());
        this.liensImportXMLPart.addLiensImport(motcleImport.getLiensImport());
        this.closeTag("motcleimport");
    }

    private void addMergeMotcleImport(ThesaurusImport.MergeMotcleImport motcleImport) throws IOException {
        this.startOpenTag("motcleimport");
        this.addAttribute("id", motcleImport.getMotcleId());
        this.addAttribute("destination", motcleImport.getDestinationMotcle().getId());
        this.closeEmptyTag();
    }

    private void addLabelChange(LabelChange labelChange) throws IOException {
        LabelUtils.addLabels(this, labelChange.getChangedLabels());
        for (Lang lang : labelChange.getRemovedLangList()) {
            this.startOpenTag("label");
            this.addAttribute("xml:lang", lang.toString());
            this.closeEmptyTag();
        }
    }

    private void addAttributeChange(AttributeChange attributeChange) throws IOException {
        AttributeUtils.addAttributes(this, attributeChange.getChangedAttributes());
        for (AttributeKey attributeKey : attributeChange.getRemovedAttributeKeyList()) {
            this.startOpenTag("attr");
            this.addAttribute("ns", attributeKey.getNameSpace());
            this.addAttribute("key", attributeKey.getLocalKey());
            this.closeEmptyTag();
        }
    }
}

