/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.selection.FicheCondition;

public class FicheConditionBuilder {
    private final List<FicheCondition.Entry> entryList = new ArrayList<FicheCondition.Entry>();
    private String logicalOperator = "and";

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public FicheConditionBuilder setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
        return this;
    }

    public FicheConditionBuilder addEntry(FicheCondition.Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry is null");
        }
        this.entryList.add(entry);
        return this;
    }

    public FicheCondition toFicheCondition() {
        EntryList finalEntryList = new EntryList(this.entryList.toArray(new FicheCondition.Entry[this.entryList.size()]));
        return new InternalFicheCondition(this.logicalOperator, finalEntryList);
    }

    public static FicheConditionBuilder init() {
        return new FicheConditionBuilder();
    }

    private static class EntryList
    extends AbstractList<FicheCondition.Entry>
    implements RandomAccess {
        private final FicheCondition.Entry[] array;

        private EntryList(FicheCondition.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public FicheCondition.Entry get(int index) {
            return this.array[index];
        }
    }

    private static class InternalFicheCondition
    implements FicheCondition {
        private final String logicalOperator;
        private final List<FicheCondition.Entry> entryList;

        private InternalFicheCondition(String logicalOperator, List<FicheCondition.Entry> entryList) {
            this.logicalOperator = logicalOperator;
            this.entryList = entryList;
        }

        @Override
        public String getLogicalOperator() {
            return this.logicalOperator;
        }

        @Override
        public List<FicheCondition.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

