/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.pointeurs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.pointeurs.FichePointeurImpl;
import net.fichotheque.utils.pointeurs.PointeurFactory;

abstract class AbstractPointeur
implements SubsetItemPointeur {
    private final Subset mainSubset;
    private final Map<SubsetKey, CroisementsBuffer> croisementListBufferMap = new HashMap<SubsetKey, CroisementsBuffer>();
    private SubsetItem currentSubsetItem;
    private Map<SubsetKey, SubsetItemPointeur> parentagePointeurMap;
    private boolean isParentageMapInit = false;
    private Map<String, Object> currentObjectMap;
    private Map<String, Object> pointeurObjectMap;
    private Map<SubsetKey, SubsetItemPointeur> associatedPointeurMap;

    public AbstractPointeur(Subset subset) {
        this.mainSubset = subset;
    }

    @Override
    public Subset getSubset() {
        return this.mainSubset;
    }

    @Override
    public SubsetItem getCurrentSubsetItem() {
        return this.currentSubsetItem;
    }

    @Override
    public SubsetItemPointeur getAssociatedPointeur(Subset subset) {
        SubsetItemPointeur pointeur;
        SubsetKey subsetKey = subset.getSubsetKey();
        if (this.associatedPointeurMap == null) {
            this.associatedPointeurMap = new HashMap<SubsetKey, SubsetItemPointeur>();
        }
        if ((pointeur = this.associatedPointeurMap.get(subsetKey)) == null) {
            pointeur = PointeurFactory.newSubsetItemPointeur(subset);
            this.associatedPointeurMap.put(subsetKey, pointeur);
        }
        return pointeur;
    }

    @Override
    public void setCurrentSubsetItem(int id) {
        if (this.currentSubsetItem != null && this.currentSubsetItem.getId() == id) {
            return;
        }
        this.innerSetCurrentSubsetItem(this.mainSubset.getSubsetItemById(id));
    }

    @Override
    public void setCurrentSubsetItem(SubsetItem subsetItem) {
        if (this.currentSubsetItem != null && subsetItem != null && this.currentSubsetItem.equals(subsetItem)) {
            return;
        }
        this.innerSetCurrentSubsetItem(subsetItem);
    }

    private void innerSetCurrentSubsetItem(SubsetItem subsetItem) {
        this.currentSubsetItem = subsetItem;
        for (CroisementsBuffer buffer : this.croisementListBufferMap.values()) {
            buffer.setCurrent(subsetItem);
        }
        if (this.parentagePointeurMap != null) {
            for (SubsetItemPointeur pointeur : this.parentagePointeurMap.values()) {
                if (subsetItem == null) {
                    pointeur.setCurrentSubsetItem(null);
                    continue;
                }
                pointeur.setCurrentSubsetItem(subsetItem.getId());
            }
        }
        if (this.currentObjectMap != null) {
            this.currentObjectMap.clear();
        }
        this.initCurrentSubsetItem(subsetItem);
    }

    protected abstract void initCurrentSubsetItem(SubsetItem var1);

    @Override
    public Croisements getCroisements(Subset subset) {
        SubsetKey subsetKey = subset.getSubsetKey();
        CroisementsBuffer buffer = this.croisementListBufferMap.get(subsetKey);
        if (buffer == null) {
            buffer = new CroisementsBuffer(subset);
            buffer.setCurrent(this.currentSubsetItem);
            this.croisementListBufferMap.put(subsetKey, buffer);
        }
        return buffer.getCroisements();
    }

    @Override
    public SubsetItemPointeur getParentagePointeur(SubsetKey parentageSubsetKey) {
        if (!this.isParentageMapInit) {
            this.initParentageMap();
        }
        SubsetItemPointeur result = null;
        if (this.parentagePointeurMap != null) {
            result = this.parentagePointeurMap.get(parentageSubsetKey);
        }
        if (result == null) {
            throw new IllegalArgumentException("Not a parentage subset: " + parentageSubsetKey);
        }
        if (this.currentSubsetItem == null) {
            result.setCurrentSubsetItem(null);
        } else {
            result.setCurrentSubsetItem(this.currentSubsetItem.getId());
        }
        return result;
    }

    @Override
    public Object getCurrentObject(String objectName) {
        if (this.currentObjectMap == null) {
            return null;
        }
        return this.currentObjectMap.get(objectName);
    }

    @Override
    public void putCurrentObject(String objectName, Object object) {
        if (this.currentObjectMap == null) {
            this.currentObjectMap = new HashMap<String, Object>();
        }
        this.currentObjectMap.put(objectName, object);
    }

    @Override
    public Object getPointeurObject(String objectName) {
        if (this.pointeurObjectMap == null) {
            return null;
        }
        return this.pointeurObjectMap.get(objectName);
    }

    @Override
    public void putPointeurObject(String objectName, Object object) {
        if (this.pointeurObjectMap == null) {
            this.pointeurObjectMap = new HashMap<String, Object>();
        }
        this.pointeurObjectMap.put(objectName, object);
    }

    private void initParentageMap() {
        Corpus corpus;
        Subset masterSubset = null;
        List<Corpus> corpusList = this.mainSubset instanceof Corpus ? ((masterSubset = (corpus = (Corpus)this.mainSubset).getMasterSubset()) != null ? masterSubset.getSatelliteCorpusList() : corpus.getSatelliteCorpusList()) : this.mainSubset.getSatelliteCorpusList();
        if (masterSubset != null || !corpusList.isEmpty()) {
            this.parentagePointeurMap = new HashMap<SubsetKey, SubsetItemPointeur>();
            if (masterSubset != null) {
                this.parentagePointeurMap.put(masterSubset.getSubsetKey(), PointeurFactory.newSubsetItemPointeur(masterSubset));
            }
            for (Corpus corpus2 : corpusList) {
                this.parentagePointeurMap.put(corpus2.getSubsetKey(), new FichePointeurImpl(corpus2, false));
            }
        }
        this.isParentageMapInit = true;
    }

    private static class CroisementsBuffer {
        private final Subset otherSubset;
        private Croisements currentCroisements;
        private int currentId;

        private CroisementsBuffer(Subset otherSubset) {
            this.otherSubset = otherSubset;
            this.initToNull();
        }

        private Croisements getCroisements() {
            return this.currentCroisements;
        }

        private void initToNull() {
            this.currentId = -1;
            this.currentCroisements = CroisementUtils.EMPTY_CROISEMENTS;
        }

        private void setCurrent(SubsetItem subsetItem) {
            if (subsetItem == null) {
                if (this.currentId != -1) {
                    this.initToNull();
                }
            } else {
                int newId = subsetItem.getId();
                if (newId != this.currentId) {
                    this.currentId = newId;
                    this.currentCroisements = this.otherSubset.getFichotheque().getCroisements(subsetItem, this.otherSubset);
                }
            }
        }
    }
}

