/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.io.IOException;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableDefItem;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableParameterDef;
import net.fichotheque.format.FichothequeFormatDef;
import net.fichotheque.format.SourceLabelProvider;
import net.fichotheque.utils.FichothequeFormatUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.format.Calcul;
import net.mapeadores.util.format.FormatUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.StringUtils;

public final class TableDefUtils {
    private TableDefUtils() {
    }

    public static boolean isConvertEmptyToNull(ColDef colDef) {
        return FormatUtils.toBoolean(colDef.getParameterValue("null"));
    }

    public static Calcul getCalcul(ColDef colDef) {
        return FormatUtils.toCalcul(colDef.getParameterValue("calc"));
    }

    public static boolean isWithColumnSum(ColDef colDef) {
        return FormatUtils.toBoolean(colDef.getParameterValue("columnsum"));
    }

    public static boolean isWithSum(ColDef colDef) {
        return colDef.getParameterValue("sum") != null;
    }

    public static short checkSumCastType(ColDef colDef) {
        Object value = colDef.getParameterValue("sum");
        if (value == null || !(value instanceof Short)) {
            return 0;
        }
        short sumCastType = (Short)value;
        if (sumCastType == 0) {
            sumCastType = colDef.getCastType();
        }
        return sumCastType;
    }

    public static boolean isFormula(ColDef colDef) {
        return colDef.getParameterValue("formula") != null;
    }

    public static short checkFormulaCastType(ColDef colDef) {
        Object value = colDef.getParameterValue("formula");
        if (value == null || !(value instanceof Short)) {
            return 0;
        }
        return (Short)value;
    }

    public static Labels getLabels(ColDef colDef, SourceLabelProvider sourceLabelProvider, Subset subset) {
        Labels labels = colDef.getCustomLabels();
        if (labels != null) {
            return labels;
        }
        if (sourceLabelProvider == null) {
            return null;
        }
        if (colDef instanceof FormatColDef) {
            return sourceLabelProvider.getLabels(subset, ((FormatColDef)colDef).getFichothequeFormatDef().getFormatSourceKeyList().get(0));
        }
        return null;
    }

    public static String getColTitle(ColDef colDef, Lang lang, SourceLabelProvider sourceLabelProvider, Subset subset) {
        Labels labels = TableDefUtils.getLabels(colDef, sourceLabelProvider, subset);
        if (labels != null) {
            return labels.seekLabelString(lang, colDef.getColName());
        }
        return colDef.getColName();
    }

    public static void writeTableDef(Appendable appendable, TableDef tableDef) throws IOException {
        boolean next = false;
        for (TableDefItem defItem : tableDef.getDefItemList()) {
            if (next) {
                appendable.append("\n");
            } else {
                next = true;
            }
            if (defItem instanceof FormatColDef) {
                FormatColDef formatColDef = (FormatColDef)defItem;
                TableDefUtils.writeNameLine(appendable, formatColDef.getColName(), formatColDef.getCustomLabels());
                FichothequeFormatDef ficheFormatDef = formatColDef.getFichothequeFormatDef();
                FichothequeFormatUtils.appendLines(ficheFormatDef, appendable);
                continue;
            }
            if (defItem instanceof TableInclusionDef) {
                TableInclusionDef tableInclusionDef = (TableInclusionDef)defItem;
                appendable.append("%");
                TableDefUtils.writeNameLine(appendable, TableDefUtils.getCompleteName(tableInclusionDef), tableInclusionDef.getLabels());
                for (String configLine : tableInclusionDef.getConfigLineList()) {
                    appendable.append(configLine);
                    appendable.append('\n');
                }
                continue;
            }
            if (!(defItem instanceof TableParameterDef)) continue;
            TableParameterDef tableParameterDef = (TableParameterDef)defItem;
            String name = tableParameterDef.getParameterName();
            String value = tableParameterDef.getParameterValue();
            if (value.indexOf(10) != -1) {
                appendable.append("!!start_");
                appendable.append(name);
                appendable.append('\n');
                appendable.append(value);
                if (value.charAt(value.length() - 1) != '\n') {
                    appendable.append('\n');
                }
                appendable.append("!!end_");
                appendable.append(name);
                appendable.append('\n');
                continue;
            }
            appendable.append('!');
            appendable.append(name);
            appendable.append('=');
            appendable.append(tableParameterDef.getParameterValue());
            appendable.append('\n');
        }
    }

    private static void writeNameLine(Appendable appendable, String colName, Labels customLabels) throws IOException {
        appendable.append(colName);
        if (customLabels != null) {
            appendable.append(" > ");
            boolean next = false;
            for (Label label : customLabels) {
                if (next) {
                    appendable.append(',');
                } else {
                    next = true;
                }
                appendable.append(label.getLang().toString());
                appendable.append("=\"");
                StringUtils.escapeDoubleQuote(label.getLabelString(), appendable);
                appendable.append("\"");
            }
        }
        appendable.append('\n');
    }

    public static MessageHandler toFormatDefMessageHandler(LineMessageHandler lineMessageHandler, int coldDefStartLineNumber) {
        return new FormatDefMessageHandler(lineMessageHandler, coldDefStartLineNumber);
    }

    public static String getCompleteName(TableInclusionDef tableInclusionDef) {
        String nameSpace = tableInclusionDef.getNameSpace();
        String localName = tableInclusionDef.getLocalName();
        if (localName.length() == 0) {
            return nameSpace;
        }
        return nameSpace + ":" + localName;
    }

    public static ColDef toColDef(String colName, @Nullable Labels customLabels) {
        return new SimpleColDef(colName, customLabels);
    }

    public static FormatColDef toFormatColDef(String colName, FichothequeFormatDef ficheFormatDef) {
        return TableDefUtils.toFormatColDef(colName, ficheFormatDef, null);
    }

    public static FormatColDef toFormatColDef(String colName, FichothequeFormatDef ficheFormatDef, @Nullable Labels customLabels) {
        return new InternalFormatColDef(colName, ficheFormatDef, customLabels);
    }

    public static TableInclusionDef newTableInclusionDef(String completeName, Labels customLabels, String[] lines) {
        String nameSpace = completeName;
        String localName = "";
        int idx = completeName.indexOf(":");
        if (idx != -1) {
            nameSpace = completeName.substring(0, idx);
            localName = completeName.substring(idx + 1);
        }
        return new InternalTableInclusionDef(nameSpace, localName, customLabels, StringUtils.wrap(lines));
    }

    public static TableDef toTableDef(List<TableDefItem> defItemList) {
        return new InternalTableDef(TableDefUtils.wrap(defItemList.toArray(new TableDefItem[defItemList.size()])));
    }

    public static List<TableDefItem> wrap(TableDefItem[] array) {
        return new TableDefItemList(array);
    }

    public static List<ColDef> wrap(ColDef[] array) {
        return new ColDefList(array);
    }

    private static class FormatDefMessageHandler
    implements MessageHandler {
        private final LineMessageHandler lineMessageHandler;
        private final int coldDefStartLineNumber;

        private FormatDefMessageHandler(LineMessageHandler lineMessageHandler, int coldDefStartLineNumber) {
            this.lineMessageHandler = lineMessageHandler;
            this.coldDefStartLineNumber = coldDefStartLineNumber;
        }

        @Override
        public void addMessage(String category, Message message) {
            int lineDiff = this.getLineDiff(category);
            int lineNumber = this.coldDefStartLineNumber + lineDiff;
            this.lineMessageHandler.addMessage(category, lineNumber, message);
        }

        private int getLineDiff(String formatErrorCategory) {
            switch (formatErrorCategory) {
                case "severe.format.instruction": 
                case "warning.format.instruction": {
                    return 3;
                }
                case "severe.format.pattern": {
                    return 2;
                }
                case "severe.format.source": {
                    return 1;
                }
            }
            return 0;
        }
    }

    private static class SimpleColDef
    implements ColDef {
        private final String colName;
        private final Labels customLabels;

        private SimpleColDef(String colName, Labels customLabels) {
            this.colName = colName;
            this.customLabels = customLabels;
        }

        @Override
        public String getColName() {
            return this.colName;
        }

        @Override
        public Labels getCustomLabels() {
            return this.customLabels;
        }

        @Override
        public Object getParameterValue(String paramKey) {
            return null;
        }
    }

    private static class InternalFormatColDef
    implements FormatColDef {
        private final String colName;
        private final FichothequeFormatDef ficheFormatDef;
        private final Labels customLabels;

        private InternalFormatColDef(String colName, FichothequeFormatDef ficheFormatDef, Labels customLabels) {
            this.colName = colName;
            this.ficheFormatDef = ficheFormatDef;
            this.customLabels = customLabels;
        }

        @Override
        public String getColName() {
            return this.colName;
        }

        @Override
        public Labels getCustomLabels() {
            return this.customLabels;
        }

        @Override
        public FichothequeFormatDef getFichothequeFormatDef() {
            return this.ficheFormatDef;
        }
    }

    private static class InternalTableInclusionDef
    implements TableInclusionDef {
        private final String nameSpace;
        private final String localName;
        private final Labels labels;
        private final List<String> configLineList;

        private InternalTableInclusionDef(String nameSpace, String localName, Labels labels, List<String> configLineList) {
            this.nameSpace = nameSpace;
            this.localName = localName;
            this.labels = labels;
            this.configLineList = configLineList;
        }

        @Override
        public String getNameSpace() {
            return this.nameSpace;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        @Override
        public Labels getLabels() {
            return this.labels;
        }

        @Override
        public List<String> getConfigLineList() {
            return this.configLineList;
        }
    }

    private static class InternalTableDef
    implements TableDef {
        private final List<TableDefItem> defItemList;

        private InternalTableDef(List<TableDefItem> defItemList) {
            this.defItemList = defItemList;
        }

        @Override
        public List<TableDefItem> getDefItemList() {
            return this.defItemList;
        }
    }

    private static class TableDefItemList
    extends AbstractList<TableDefItem>
    implements RandomAccess {
        private final TableDefItem[] array;

        private TableDefItemList(TableDefItem[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TableDefItem get(int index) {
            return this.array[index];
        }
    }

    private static class ColDefList
    extends AbstractList<ColDef>
    implements RandomAccess {
        private final ColDef[] array;

        private ColDefList(ColDef[] colDefArray) {
            this.array = colDefArray;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ColDef get(int i) {
            return this.array[i];
        }
    }
}

