/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.croisement;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.tools.parsers.croisement.DocumentAddToken;
import net.fichotheque.tools.parsers.croisement.DocumentChangeToken;
import net.fichotheque.tools.parsers.croisement.DocumentCreateToken;
import net.fichotheque.tools.parsers.croisement.DocumentMultipartToken;
import net.fichotheque.tools.parsers.croisement.DocumentOrderManager;
import net.fichotheque.tools.parsers.croisement.DocumentRemoveToken;
import net.fichotheque.tools.parsers.croisement.TokenKey;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.StringUtils;

public class DocumentTokenParser {
    private static final FileName DEFAULT_FILENAME = FileName.build("file.octetstream");
    private final SubsetItem mainSubsetItem;
    private final Map<String, DocumentMultipartToken> multipartTokenMap = new LinkedHashMap<String, DocumentMultipartToken>();
    private final File tmpDirectory;
    private final List<DocumentRemoveToken> documentRemoveTokenList = new ArrayList<DocumentRemoveToken>();
    private final List<DocumentCreateToken> documentCreateTokenList = new ArrayList<DocumentCreateToken>();
    private final List<DocumentChangeToken> documentChangeTokenList = new ArrayList<DocumentChangeToken>();
    private final List<DocumentAddToken> documentAddTokenList = new ArrayList<DocumentAddToken>();
    private final Set<Document> removeSet = new HashSet<Document>();
    private final Map<IncludeKey, DocumentOrderManager> orderManagerMap = new HashMap<IncludeKey, DocumentOrderManager>();

    public DocumentTokenParser(SubsetItem mainSubsetItem, File tmpDirectory) {
        this.mainSubsetItem = mainSubsetItem;
        this.tmpDirectory = tmpDirectory;
    }

    public void addFromMultipart(TokenKey tokenKey, FileValue[] fileValues) {
        IncludeKey includeKey = tokenKey.getIncludeKey();
        SubsetKey addendaKey = includeKey.getSubsetKey();
        if (!addendaKey.isAddendaSubset()) {
            throw new IllegalArgumentException("not an addenda Parameter: " + tokenKey.getParamName());
        }
        Addenda addenda = (Addenda)this.mainSubsetItem.getFichotheque().getSubset(addendaKey);
        if (addenda == null) {
            return;
        }
        String mode = includeKey.getMode();
        int weight = includeKey.getWeightFilter();
        for (FileValue fileValue : fileValues) {
            String baseName;
            DocumentMultipartToken documentMultipartToken;
            FileName fileName;
            if (fileValue.length() < 1L) {
                fileValue.free();
                continue;
            }
            try {
                fileName = FileName.parse(fileValue.getName(), "octetstream");
            }
            catch (ParseException pe) {
                fileName = DEFAULT_FILENAME;
            }
            String extension = fileName.getExtension().toLowerCase();
            if (!AddendaUtils.testExtension(extension)) {
                extension = "octetstream";
            }
            if ((documentMultipartToken = this.multipartTokenMap.get(baseName = fileName.getBasename())) == null) {
                documentMultipartToken = new DocumentMultipartToken(baseName, addenda, mode, weight);
                this.multipartTokenMap.put(baseName, documentMultipartToken);
            }
            documentMultipartToken.add(extension, fileValue);
        }
    }

    public void parse(TokenKey tokenKey, String[] parameterValues) {
        IncludeKey includeKey = tokenKey.getIncludeKey();
        SubsetKey addendaKey = includeKey.getSubsetKey();
        if (!addendaKey.isAddendaSubset()) {
            throw new IllegalArgumentException("not an addenda Parameter: " + tokenKey.getParamName());
        }
        Addenda addenda = (Addenda)this.mainSubsetItem.getFichotheque().getSubset(addendaKey);
        if (addenda == null) {
            return;
        }
        String[] values = DocumentTokenParser.tokenize(parameterValues);
        switch (tokenKey.getSubname()) {
            case "create": {
                for (String value : values) {
                    DocumentCreateToken documentCreateToken = DocumentCreateToken.parse(value, addenda, includeKey);
                    if (documentCreateToken == null) continue;
                    this.documentCreateTokenList.add(documentCreateToken);
                }
                break;
            }
            case "remove": {
                for (String value : values) {
                    DocumentRemoveToken documentRemoveToken = DocumentRemoveToken.parse(value, addenda, includeKey);
                    if (documentRemoveToken == null) continue;
                    this.documentRemoveTokenList.add(documentRemoveToken);
                    this.removeSet.add(documentRemoveToken.getDocument());
                }
                break;
            }
            case "change": {
                for (String value : values) {
                    DocumentChangeToken documentChangeToken = DocumentChangeToken.parse(value, addenda);
                    if (documentChangeToken == null) continue;
                    this.documentChangeTokenList.add(documentChangeToken);
                }
                break;
            }
            case "add": {
                for (String value : values) {
                    DocumentAddToken documentAddToken = DocumentAddToken.parse(value, addenda, includeKey);
                    if (documentAddToken == null) continue;
                    this.documentAddTokenList.add(documentAddToken);
                }
                break;
            }
            case "order": {
                for (String value : values) {
                    Object orderObject = this.parseOrderToken(value);
                    if (orderObject == null) continue;
                    DocumentOrderManager orderManager = this.getOrderManager(addenda, includeKey);
                    orderManager.add(orderObject);
                }
                break;
            }
        }
    }

    public void save(FichothequeEditor fichothequeEditor) {
        LienBuffer lienBuffer;
        CroisementEditor croisementEditor = fichothequeEditor.getCroisementEditor();
        CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendOrWeightReplaceEngine(this.mainSubsetItem);
        for (DocumentRemoveToken documentRemoveToken : this.documentRemoveTokenList) {
            croisementChangeEngine.removeLien(documentRemoveToken.getDocument(), documentRemoveToken.getMode());
        }
        for (DocumentMultipartToken documentMultipartToken : this.multipartTokenMap.values()) {
            lienBuffer = documentMultipartToken.save(fichothequeEditor);
            if (lienBuffer == null) continue;
            croisementChangeEngine.addLien(lienBuffer);
        }
        for (DocumentChangeToken documentChangeToken : this.documentChangeTokenList) {
            documentChangeToken.save(fichothequeEditor, this.tmpDirectory);
        }
        for (DocumentCreateToken documentCreateToken : this.documentCreateTokenList) {
            lienBuffer = documentCreateToken.save(fichothequeEditor, this.tmpDirectory);
            if (lienBuffer == null) continue;
            DocumentOrderManager orderManager = this.orderManagerMap.get(documentCreateToken.getIncludeKey());
            if (orderManager != null) {
                orderManager.replace(documentCreateToken.getNewBasename(), lienBuffer.getSubsetItem().getId());
            }
            croisementChangeEngine.addLien(lienBuffer);
        }
        for (DocumentAddToken documentAddToken : this.documentAddTokenList) {
            croisementChangeEngine.addLien(documentAddToken.toLienBuffer());
        }
        croisementEditor.updateCroisements(this.mainSubsetItem, croisementChangeEngine.toCroisementChanges());
        for (Document document : this.removeSet) {
            if (!fichothequeEditor.getFichotheque().isRemoveable(document)) continue;
            fichothequeEditor.getAddendaEditor(document.getSubsetKey()).removeDocument(document);
        }
        for (DocumentOrderManager orderManager : this.orderManagerMap.values()) {
            orderManager.save(croisementEditor);
        }
    }

    private static String[] tokenize(String[] values) {
        LinkedHashSet<String> tokenSet = new LinkedHashSet<String>();
        for (String value : values) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTokens(value, ';', (short)2)) {
                tokenSet.add(token);
            }
        }
        return tokenSet.toArray(new String[tokenSet.size()]);
    }

    private DocumentOrderManager getOrderManager(Addenda addenda, IncludeKey includeKey) {
        DocumentOrderManager orderManager = this.orderManagerMap.get(includeKey);
        if (orderManager == null) {
            orderManager = new DocumentOrderManager(this.mainSubsetItem, addenda, includeKey.getMode(), includeKey.getWeightFilter());
            this.orderManagerMap.put(includeKey, orderManager);
        }
        return orderManager;
    }

    private Object parseOrderToken(String token) {
        int idx = token.indexOf(61);
        if (idx < 0) {
            return null;
        }
        String type = token.substring(0, idx).trim();
        String value = token.substring(idx + 1).trim();
        switch (type) {
            case "id": {
                try {
                    int id = Integer.parseInt(value);
                    return id;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case "bn": {
                return value;
            }
        }
        return null;
    }
}

