/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import net.fichotheque.externalsource.ExternalSource;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.tools.parsers.DynamicEdit;
import net.fichotheque.tools.parsers.croisement.WeightMotcleToken;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.text.CleanedString;

final class DynamicEditFactory {
    private DynamicEditFactory() {
    }

    static DynamicEdit newInstance(DynamicEdit.Parameters parameters) {
        PolicyProvider policyProvider = parameters.getParseContext().getPolicyProvider();
        if (policyProvider == null) {
            return null;
        }
        DynamicEditPolicy dynamicEditPolicy = policyProvider.getDynamicEditPolicy(parameters.getMainThesaurus());
        boolean withIdalpha = parameters.getMainThesaurus().isIdalphaType();
        if (dynamicEditPolicy instanceof DynamicEditPolicy.Allow) {
            if (withIdalpha) {
                return null;
            }
            return new Allow(parameters);
        }
        if (dynamicEditPolicy instanceof DynamicEditPolicy.Transfer) {
            if (withIdalpha) {
                return null;
            }
            return new Transfer(parameters, (DynamicEditPolicy.Transfer)dynamicEditPolicy);
        }
        if (dynamicEditPolicy instanceof DynamicEditPolicy.Check) {
            if (withIdalpha) {
                return null;
            }
            return new Check(parameters, (DynamicEditPolicy.Check)dynamicEditPolicy);
        }
        if (dynamicEditPolicy instanceof DynamicEditPolicy.External) {
            ExternalSource externalSource = parameters.getParseContext().getExternalSourceProvider().getExternalSource(((DynamicEditPolicy.External)dynamicEditPolicy).getExternalSourceDef());
            if (externalSource != null) {
                return new External(parameters, externalSource);
            }
            return null;
        }
        return null;
    }

    private static class Allow
    extends DynamicEdit {
        Allow(DynamicEdit.Parameters parameters) {
            super(parameters);
        }

        @Override
        public void editToken(WeightMotcleToken motcleToken) {
            if (motcleToken.isIdBundle()) {
                return;
            }
            Motcle motcle = this.createMotcle(motcleToken.getText());
            this.createLien(motcle, motcleToken.getWeight());
        }
    }

    private static class Transfer
    extends DynamicEdit {
        private final DynamicEditPolicy.Transfer transferPolicy;

        Transfer(DynamicEdit.Parameters parameters, DynamicEditPolicy.Transfer transferPolicy) {
            super(parameters);
            this.transferPolicy = transferPolicy;
        }

        @Override
        public void editToken(WeightMotcleToken motcleToken) {
            if (motcleToken.isIdBundle()) {
                return;
            }
            CleanedString labelText = motcleToken.getText();
            Thesaurus transferThesaurus = ThesaurusUtils.getTransferThesaurus(this.parseContext.getFichotheque(), this.transferPolicy);
            Motcle transferMotcle = this.getMotcle(transferThesaurus, labelText);
            if (transferMotcle == null) {
                transferMotcle = this.createMotcle(transferThesaurus, labelText);
            }
            this.appendLien(transferMotcle, motcleToken.getWeight());
        }
    }

    private static class Check
    extends DynamicEdit {
        private final DynamicEditPolicy.Check checkPolicy;

        Check(DynamicEdit.Parameters parameters, DynamicEditPolicy.Check checkPolicy) {
            super(parameters);
            this.checkPolicy = checkPolicy;
        }

        @Override
        public void editToken(WeightMotcleToken motcleToken) {
            if (motcleToken.isIdBundle()) {
                return;
            }
            CleanedString labelText = motcleToken.getText();
            Thesaurus[] checkThesaurusArray = ThesaurusUtils.getCheckThesaurusArray(this.parseContext.getFichotheque(), this.checkPolicy);
            boolean done = false;
            for (Thesaurus checkThesaurus : checkThesaurusArray) {
                Motcle checkMotcle = this.getMotcle(checkThesaurus, labelText);
                if (checkMotcle == null) continue;
                this.appendLien(checkMotcle, motcleToken.getWeight());
                done = true;
                break;
            }
            if (!done) {
                Motcle motcle = this.createMotcle(labelText);
                this.createLien(motcle, motcleToken.getWeight());
            }
        }
    }

    private static class External
    extends DynamicEdit {
        private final ExternalSource externalSource;

        External(DynamicEdit.Parameters parameters, ExternalSource externalSource) {
            super(parameters);
            this.externalSource = externalSource;
        }

        @Override
        public void editToken(WeightMotcleToken motcleToken) {
            Motcle newMotcle = motcleToken.isIdBundle() ? this.externalSource.getMotcle(this.parameters.getParseContext().getFichothequeEditor(), this.parameters.getMainThesaurus(), motcleToken.getId()) : this.externalSource.getMotcle(this.parameters.getParseContext().getFichothequeEditor(), this.parameters.getMainThesaurus(), motcleToken.getText().toString(), this.parameters.getLang());
            if (newMotcle != null) {
                this.createLien(newMotcle, motcleToken.getWeight());
            }
        }
    }
}

