/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.RemoveCorpusImportBuilder;
import net.fichotheque.tools.importation.parsers.CorpusRowParser;
import net.fichotheque.tools.importation.parsers.Row;

class CorpusRemoveRowParser
extends CorpusRowParser {
    private final RemoveCorpusImportBuilder removeCorpusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;
    private final int idIndex;

    CorpusRemoveRowParser(RemoveCorpusImportBuilder removeCorpusImportBuilder, ParseResultBuilder parseResultBuilder, int idIndex) {
        this.removeCorpusImportBuilder = removeCorpusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.idIndex = idIndex;
    }

    @Override
    public RemoveCorpusImportBuilder getCorpusImportBuilder() {
        return this.removeCorpusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        if (row.getColumnCount() <= this.idIndex) {
            this.parseResultBuilder.missingIdColumn(rowNumber);
            return;
        }
        String idString = row.getColumnValue(this.idIndex).trim();
        Corpus corpus = this.removeCorpusImportBuilder.getCorpus();
        FicheMeta ficheMeta = null;
        try {
            int id = Integer.parseInt(idString);
            ficheMeta = corpus.getFicheMetaById(id);
            if (ficheMeta == null) {
                this.parseResultBuilder.unknownId(rowNumber, idString);
            }
        }
        catch (NumberFormatException nfe) {
            this.parseResultBuilder.notIntegerId(rowNumber, idString);
        }
        if (ficheMeta != null) {
            this.removeCorpusImportBuilder.add(ficheMeta);
        }
    }

    static CorpusRemoveRowParser newInstance(String[] fieldArray, RemoveCorpusImportBuilder removeCorpusImportBuilder, ParseResultBuilder parseResultBuilder) {
        int fieldIndex = -1;
        int length = fieldArray.length;
        for (int i = 0; i < length; ++i) {
            FieldKey fieldKey;
            String field = fieldArray[i].trim();
            try {
                fieldKey = FieldKey.parse(field);
            }
            catch (ParseException pe) {
                continue;
            }
            if (!CorpusRemoveRowParser.isIdField(fieldKey) || fieldIndex != -1) continue;
            fieldIndex = i;
        }
        if (fieldIndex == -1) {
            parseResultBuilder.missingColumn("id");
        }
        if (fieldIndex != -1) {
            return new CorpusRemoveRowParser(removeCorpusImportBuilder, parseResultBuilder, fieldIndex);
        }
        return null;
    }

    private static boolean isIdField(FieldKey fieldKey) {
        switch (fieldKey.getKeyString()) {
            case "id": {
                return true;
            }
        }
        return false;
    }
}

