/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.directory;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.TreeSet;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.importation.ImportationContext;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.dom.FicheImportDOMReader;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public final class CorpusImportLoad {
    private static final CorpusImport.FicheImport NULL_FICHEIMPORT = new NullFicheImport();

    private CorpusImportLoad() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CorpusImport load(Fichotheque fichotheque, File dir, ImportationContext importationContext) {
        String type;
        Corpus corpus;
        File initFile = new File(dir, "init.txt");
        if (!initFile.exists()) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(initFile), "UTF-8"));
            try {
                String corpusString = reader.readLine();
                try {
                    SubsetKey corpusKey = SubsetKey.parse(corpusString);
                    corpus = (Corpus)fichotheque.getSubset(corpusKey);
                }
                catch (ParseException pe) {
                    CorpusImport corpusImport = null;
                    reader.close();
                    return corpusImport;
                }
                type = reader.readLine();
                try {
                    type = CorpusImport.checkType(type);
                }
                catch (IllegalArgumentException iae) {
                    CorpusImport corpusImport = null;
                    reader.close();
                    return corpusImport;
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        switch (type) {
            case "edit": {
                return CorpusImportLoad.loadEdit(corpus, dir, importationContext);
            }
        }
        return null;
    }

    private static CorpusImport loadEdit(Corpus corpus, File dir, ImportationContext importationContext) {
        File[] files = dir.listFiles();
        TreeSet<String> sortedSet = new TreeSet<String>();
        for (File f : dir.listFiles()) {
            String name;
            if (f.isDirectory() || (name = f.getName()).length() <= 4 || !name.endsWith(".xml")) continue;
            sortedSet.add(name);
        }
        ArrayList fileNameList = new ArrayList(sortedSet);
        return new DirCorpusImport(corpus, dir, fileNameList, importationContext);
    }

    private static class DirCorpusImport
    implements CorpusImport {
        private final Corpus corpus;
        private final ImportationContext importationContext;
        private final File dir;
        private final List<String> fileNameList;
        private final FicheImportList ficheImportList = new FicheImportList();

        private DirCorpusImport(Corpus corpus, File dir, List<String> fileNameList, ImportationContext importationContext) {
            this.corpus = corpus;
            this.importationContext = importationContext;
            this.dir = dir;
            this.fileNameList = fileNameList;
        }

        @Override
        public Corpus getCorpus() {
            return this.corpus;
        }

        @Override
        public String getType() {
            return "edit";
        }

        @Override
        public List<CorpusImport.FicheImport> getFicheImportList() {
            return this.ficheImportList;
        }

        private class FicheImportList
        extends AbstractList<CorpusImport.FicheImport>
        implements RandomAccess {
            private FicheImportList() {
            }

            @Override
            public int size() {
                return DirCorpusImport.this.fileNameList.size();
            }

            @Override
            public CorpusImport.FicheImport get(int index) {
                String fileName = (String)DirCorpusImport.this.fileNameList.get(index);
                File f = new File(DirCorpusImport.this.dir, fileName);
                Element rootElement = DOMUtils.readDocument(f).getDocumentElement();
                String idString = rootElement.getAttribute("id");
                if (idString.isEmpty()) {
                    return this.getEdit(-1, rootElement);
                }
                try {
                    int id = Integer.parseInt(idString);
                    return this.getEdit(id, rootElement);
                }
                catch (NumberFormatException nfe) {
                    return NULL_FICHEIMPORT;
                }
            }

            private CorpusImport.EditFicheImport getEdit(int ficheId, Element rootElement) {
                EditFicheImportBuilder ficheImportBuilder = new EditFicheImportBuilder(ficheId);
                FicheImportDOMReader.init(ficheImportBuilder, DirCorpusImport.this.corpus.getFichotheque(), DirCorpusImport.this.importationContext).read(rootElement);
                return ficheImportBuilder.toEditFicheImport();
            }
        }
    }

    private static class NullFicheImport
    implements CorpusImport.FicheImport {
        private NullFicheImport() {
        }

        @Override
        public int getFicheId() {
            return -999;
        }
    }
}

