/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.ExtractionFormatter;
import net.fichotheque.utils.FormatterUtils;

public class ExtractionTokenizer
implements Tokenizer {
    private final ExtractionFormatter extractionFormatter;

    public ExtractionTokenizer(ExtractionFormatter extractionFormatter) {
        this.extractionFormatter = extractionFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        if (formatSource.getExtractionInfo() == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return new InternalTokens(this.extractionFormatter, formatSource);
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final ExtractionFormatter extractionFormatter;
        private final FormatSource formatSource;

        private InternalTokens(ExtractionFormatter extractionFormatter, FormatSource formatSource) {
            this.extractionFormatter = extractionFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String get(int i) {
            return this.extractionFormatter.formatExtraction(this.formatSource);
        }
    }
}

