/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import net.fichotheque.tools.extraction.syntaxes.AbstractStepResolver;

public class ChainResolver
extends AbstractStepResolver {
    private static final short TOKEN_STEP = 1;
    private static final short ARGUMENTS_STEP = 2;
    private static final short ONQUOTE_STEP = 3;
    private static final short TOKEN_METHOD_STEP = 4;
    private static final short ROOT_TOKEN_STEP = 5;
    private int step = 5;
    private char currentQuote;

    private ChainResolver() {
    }

    @Override
    public void resolveChar(char carac) {
        switch (carac) {
            case ' ': {
                this.resolveSpace();
                break;
            }
            case '.': {
                this.resolveSeparator();
                break;
            }
            default: {
                this.appendChar(carac);
            }
        }
    }

    @Override
    public String getStepClassName(String textPart, boolean end) {
        switch (this.step) {
            case 5: {
                switch (textPart) {
                    case "this": 
                    case "self": {
                        return "cm-chain-keyword";
                    }
                }
                return "cm-chain-root";
            }
            case 1: {
                return this.getTokenClassName(textPart, end);
            }
            case 2: {
                return "cm-chain-argument";
            }
            case 3: {
                return "cm-string";
            }
            case 4: {
                return "cm-chain-method";
            }
        }
        return null;
    }

    private void resolveSpace() {
        boolean appendToCurrent = false;
        switch (this.step) {
            case 2: 
            case 3: {
                appendToCurrent = true;
                break;
            }
            default: {
                this.flush();
                this.step = 1;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(' ');
        } else {
            this.appendSpaceToFinal();
        }
    }

    private void resolveSeparator() {
        boolean appendToCurrent = false;
        switch (this.step) {
            case 3: {
                appendToCurrent = true;
                break;
            }
            default: {
                this.flush();
                this.step = 1;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent('.');
        } else {
            this.appendPunctuation(".");
        }
    }

    private void appendChar(char carac) {
        boolean appendToCurrent = true;
        switch (this.step) {
            case 1: 
            case 5: {
                switch (carac) {
                    case '(': {
                        this.step = 4;
                        this.flush();
                        this.appendBracket("(");
                        appendToCurrent = false;
                        this.step = 2;
                    }
                }
                break;
            }
            case 2: {
                switch (carac) {
                    case '\"': 
                    case '\'': {
                        this.currentQuote = carac;
                        this.step = 3;
                        break;
                    }
                    case ')': {
                        this.flush();
                        this.appendBracket(")");
                        appendToCurrent = false;
                        this.step = 1;
                    }
                }
                break;
            }
            case 3: {
                if (carac != this.currentQuote) break;
                this.appendToCurrent(carac);
                this.flush();
                this.step = 2;
                appendToCurrent = false;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(carac);
        }
    }

    private String getTokenClassName(String textPart, boolean lastPart) {
        if (Character.isUpperCase(textPart.charAt(0))) {
            if (lastPart) {
                return "cm-chain-constant";
            }
            return "cm-chain-class";
        }
        return "cm-chain-property";
    }

    public static String resolve(String value) {
        if (value.isEmpty()) {
            return "";
        }
        ChainResolver resolver = new ChainResolver();
        resolver.resolveText(value);
        return resolver.end();
    }
}

