/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.tools.extraction.corpus.AnneeEngine;
import net.fichotheque.tools.extraction.corpus.FieldsEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.LangueEngine;
import net.fichotheque.tools.extraction.corpus.PaysEngine;
import net.fichotheque.tools.extraction.corpus.PositionEngine;
import net.fichotheque.tools.extraction.corpus.TitreEngine;
import net.fichotheque.tools.extraction.corpus.WeightEngine;
import net.mapeadores.util.exceptions.SwitchException;

class GroupEngineProvider {
    private GroupClause groupClause;
    private GroupEngineProvider subProvider;

    GroupEngineProvider(GroupClause groupClause, GroupEngineProvider subProvider) {
        this.groupClause = groupClause;
        this.subProvider = subProvider;
    }

    GroupEngine newGroupEngine() {
        switch (this.groupClause.getGroupType()) {
            case "weight": {
                return new WeightEngine(this.groupClause, this.subProvider);
            }
            case "title": {
                return new TitreEngine(this.groupClause, this.subProvider);
            }
            case "year": {
                return new AnneeEngine(this.groupClause, this.subProvider);
            }
            case "lang": {
                return new LangueEngine(this.groupClause, this.subProvider);
            }
            case "country": {
                return new PaysEngine(this.groupClause, this.subProvider);
            }
            case "fields": {
                return new FieldsEngine(this.groupClause, this.subProvider);
            }
            case "position": {
                return new PositionEngine(this.groupClause, this.subProvider);
            }
        }
        throw new SwitchException("groupClause.getGroupeType() =  " + this.groupClause.getGroupType());
    }

    static GroupEngineProvider newInstance(GroupClause groupClause) {
        GroupClause subGroupClause = groupClause.getSubGroupClause();
        GroupEngineProvider subProvider = null;
        if (subGroupClause != null) {
            subProvider = GroupEngineProvider.newInstance(subGroupClause);
        }
        return new GroupEngineProvider(groupClause, subProvider);
    }
}

