/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.util.function.Consumer;
import net.fichotheque.metadata.FichothequeMetadataEditor;
import net.fichotheque.tools.dom.AbstractMetadataDOMReader;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FichothequeMetadataDOMReader
extends AbstractMetadataDOMReader {
    private final FichothequeMetadataEditor fichothequeMetadataEditor;

    public FichothequeMetadataDOMReader(FichothequeMetadataEditor fichothequeMetadataEditor, MessageHandler messageHandler) {
        super(fichothequeMetadataEditor, messageHandler, "short");
        this.fichothequeMetadataEditor = fichothequeMetadataEditor;
    }

    public void fillMetadata(Element element) {
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        DOMUtils.readChildren(element, new RootConsumer(attributesBuilder, "/" + element.getTagName()));
        this.flush(attributesBuilder);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final AttributesBuilder attributesBuilder;
        private final String parentXpath;

        private RootConsumer(AttributesBuilder attributesBuilder, String parentXpath) {
            this.attributesBuilder = attributesBuilder;
            this.parentXpath = parentXpath;
        }

        @Override
        public void accept(Element element) {
            if (FichothequeMetadataDOMReader.this.readCommonElement(element, this.attributesBuilder, this.parentXpath)) {
                return;
            }
            String tagname = element.getTagName();
            String xpath = this.parentXpath + "/" + tagname;
            if (tagname.equals("authority") || tagname.equals("authority-uuid")) {
                String authority = XMLUtils.getData(element);
                try {
                    FichothequeMetadataDOMReader.this.fichothequeMetadataEditor.setAuthority(authority);
                }
                catch (IllegalArgumentException pe) {
                    DomMessages.wrongElementValue(FichothequeMetadataDOMReader.this.messageHandler, xpath, authority);
                }
            } else if (tagname.equals("base-name") || tagname.equals("basedefiches-name")) {
                String name = XMLUtils.getData(element);
                try {
                    FichothequeMetadataDOMReader.this.fichothequeMetadataEditor.setBaseName(name);
                }
                catch (IllegalArgumentException pe) {
                    DomMessages.wrongElementValue(FichothequeMetadataDOMReader.this.messageHandler, xpath, name);
                }
            } else {
                DomMessages.unknownTagWarning(FichothequeMetadataDOMReader.this.messageHandler, xpath);
            }
        }
    }
}

