/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.json;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.syntax.FormSyntax;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.PropertyEligibility;
import net.mapeadores.util.localisation.Country;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.MessageLocalisationProvider;
import net.mapeadores.util.localisation.SpecialCodes;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.primitives.DegreSexagesimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.DateFormatBundle;
import net.mapeadores.util.text.StringUtils;

public final class FicheItemJson {
    private FicheItemJson() {
    }

    public static void object(JSONWriter jsonWriter, FicheItem ficheItem, PropertyEligibility propertyEligibility, LangContext langContext, Fichotheque fichotheque, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        jsonWriter.object();
        FicheItemJson.properties(jsonWriter, ficheItem, propertyEligibility, langContext, fichotheque, messageLocalisationProvider);
        jsonWriter.endObject();
    }

    public static void properties(JSONWriter jsonWriter, FicheItem ficheItem, PropertyEligibility propertyEligibility, LangContext langContext, Fichotheque fichotheque, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        if (ficheItem instanceof Item) {
            FicheItemJson.properties(jsonWriter, (Item)ficheItem, propertyEligibility);
        } else if (ficheItem instanceof DateItem) {
            FicheItemJson.properties(jsonWriter, (DateItem)ficheItem, propertyEligibility, langContext);
        } else if (ficheItem instanceof CountryItem) {
            FicheItemJson.properties(jsonWriter, (CountryItem)ficheItem, propertyEligibility, langContext, messageLocalisationProvider);
        } else if (ficheItem instanceof LanguageItem) {
            FicheItemJson.properties(jsonWriter, (LanguageItem)ficheItem, propertyEligibility, langContext, messageLocalisationProvider);
        } else if (ficheItem instanceof GeopointItem) {
            FicheItemJson.properties(jsonWriter, (GeopointItem)ficheItem, propertyEligibility, langContext, messageLocalisationProvider);
        } else if (ficheItem instanceof LinkItem) {
            FicheItemJson.properties(jsonWriter, (LinkItem)ficheItem, propertyEligibility);
        } else if (ficheItem instanceof ImageItem) {
            FicheItemJson.properties(jsonWriter, (ImageItem)ficheItem, propertyEligibility);
        } else if (ficheItem instanceof EmailItem) {
            FicheItemJson.properties(jsonWriter, (EmailItem)ficheItem, propertyEligibility);
        } else if (ficheItem instanceof NumberItem) {
            FicheItemJson.properties(jsonWriter, (NumberItem)ficheItem, propertyEligibility, langContext);
        } else if (ficheItem instanceof AmountItem) {
            FicheItemJson.properties(jsonWriter, (AmountItem)ficheItem, propertyEligibility, langContext);
        } else if (ficheItem instanceof ParaItem) {
            FicheItemJson.properties(jsonWriter, (ParaItem)ficheItem, propertyEligibility);
        } else if (ficheItem instanceof PersonItem) {
            FicheItemJson.properties(jsonWriter, (PersonItem)ficheItem, propertyEligibility, fichotheque);
        }
        if (propertyEligibility.includeProperty("formsyntax")) {
            jsonWriter.key("formsyntax");
            jsonWriter.value(FormSyntax.toString(ficheItem, fichotheque, null));
        }
    }

    public static void properties(JSONWriter jsonWriter, PersonItem personItem, PropertyEligibility propertyEligibility, Fichotheque fichotheque) throws IOException {
        Redacteur redacteur;
        String redacteurGlobalId = personItem.getRedacteurGlobalId();
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("person");
        }
        if (propertyEligibility.includeProperty("code")) {
            jsonWriter.key("code");
            if (redacteurGlobalId != null) {
                redacteur = SphereUtils.getRedacteur(fichotheque, redacteurGlobalId);
                if (redacteur != null) {
                    jsonWriter.value(redacteur.getBracketStyle());
                } else {
                    jsonWriter.value(redacteurGlobalId);
                }
            } else {
                jsonWriter.value(personItem.getPersonCore().toStandardStyle());
            }
        }
        if (propertyEligibility.includeProperty("sphere")) {
            jsonWriter.key("sphere");
            if (redacteurGlobalId != null) {
                try {
                    SubsetKey sphereKey = SphereUtils.getSubsetKey(redacteurGlobalId);
                    jsonWriter.value(sphereKey.getSubsetName());
                }
                catch (ParseException pe) {
                    jsonWriter.value("#ERR: wrong redacteurGlobaleId = " + redacteurGlobalId);
                }
            } else {
                jsonWriter.value("");
            }
        }
        if (propertyEligibility.includeProperty("login")) {
            jsonWriter.key("login");
            if (redacteurGlobalId != null) {
                redacteur = SphereUtils.getRedacteur(fichotheque, redacteurGlobalId);
                if (redacteur != null) {
                    jsonWriter.value(redacteur.getLogin());
                } else {
                    jsonWriter.value("");
                }
            } else {
                jsonWriter.value("");
            }
        }
        PersonCore personCore = SphereUtils.toPersonCore(fichotheque, personItem);
        if (propertyEligibility.includeProperty("standard")) {
            jsonWriter.key("standard");
            jsonWriter.value(personCore.toStandardStyle());
        }
        if (propertyEligibility.includeProperty("directory")) {
            jsonWriter.key("directory");
            jsonWriter.value(personCore.toDirectoryStyle(false));
        }
        if (propertyEligibility.includeProperty("updirectory")) {
            jsonWriter.key("updirectory");
            jsonWriter.value(personCore.toDirectoryStyle(true));
        }
        if (propertyEligibility.includeProperty("biblio")) {
            jsonWriter.key("biblio");
            jsonWriter.value(personCore.toBiblioStyle(false));
        }
        if (propertyEligibility.includeProperty("upbiblio")) {
            jsonWriter.key("upbiblio");
            jsonWriter.value(personCore.toBiblioStyle(true));
        }
        if (propertyEligibility.includeProperty("surname")) {
            jsonWriter.key("surname");
            jsonWriter.value(personCore.getSurname());
        }
        if (propertyEligibility.includeProperty("upsurname")) {
            jsonWriter.key("upsurname");
            jsonWriter.value(personCore.getSurname().toUpperCase());
        }
        if (propertyEligibility.includeProperty("forename")) {
            jsonWriter.key("forename");
            jsonWriter.value(personCore.getForename());
        }
        if (propertyEligibility.includeProperty("nonlatin")) {
            jsonWriter.key("nonlatin");
            jsonWriter.value(personCore.getNonlatin());
        }
        if (propertyEligibility.includeProperty("surnamefirst")) {
            jsonWriter.key("surnamefirst");
            jsonWriter.value(personCore.isSurnameFirst());
        }
        if (propertyEligibility.includeProperty("organism")) {
            jsonWriter.key("organism");
            jsonWriter.value(personItem.getOrganism());
        }
    }

    public static void properties(JSONWriter jsonWriter, DateItem dateItem, PropertyEligibility propertyEligibility, LangContext langContext) throws IOException {
        FuzzyDate date = dateItem.getDate();
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("date");
        }
        if (propertyEligibility.includeProperty("code")) {
            jsonWriter.key("code");
            jsonWriter.value(date.toString());
        }
        if (propertyEligibility.includeProperty("iso")) {
            jsonWriter.key("iso");
            jsonWriter.value(date.toISOString(false));
        }
        if (propertyEligibility.includeProperty("lastday")) {
            jsonWriter.key("lastday");
            jsonWriter.value(date.toISOString(true));
        }
        if (propertyEligibility.includeProperty("year")) {
            jsonWriter.key("year");
            jsonWriter.value(String.valueOf(date.getYear()));
        }
        if (propertyEligibility.includeProperty("isomonth")) {
            jsonWriter.key("isomonth");
            jsonWriter.value(date.toMonthString(false));
        }
        if (propertyEligibility.includeProperty("lastmonth")) {
            jsonWriter.key("lastmonth");
            jsonWriter.value(date.toMonthString(true));
        }
        if (propertyEligibility.includeProperty("labels")) {
            jsonWriter.key("labels");
            FicheItemJson.dateLabelsObject(jsonWriter, date, langContext);
        }
        if (propertyEligibility.includeProperty("monthlabels")) {
            jsonWriter.key("monthlabels");
            FicheItemJson.dateLabelsObject(jsonWriter, date.truncate((short)4), langContext);
        }
    }

    public static void properties(JSONWriter jsonWriter, CountryItem countryItem, PropertyEligibility propertyEligibility, LangContext langContext, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("country");
        }
        if (propertyEligibility.includeProperty("code")) {
            jsonWriter.key("code");
            jsonWriter.value(countryItem.getCountry().toString());
        }
        if (propertyEligibility.includeProperty("labels")) {
            jsonWriter.key("labels");
            FicheItemJson.countryLabelsObject(jsonWriter, countryItem.getCountry(), langContext, messageLocalisationProvider);
        }
    }

    public static void properties(JSONWriter jsonWriter, LanguageItem languageItem, PropertyEligibility propertyEligibility, LangContext langContext, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("lang");
        }
        if (propertyEligibility.includeProperty("code")) {
            jsonWriter.key("code");
            jsonWriter.value(languageItem.getLang().toString());
        }
        if (propertyEligibility.includeProperty("labels")) {
            jsonWriter.key("labels");
            FicheItemJson.langLabelsObject(jsonWriter, languageItem.getLang(), langContext, messageLocalisationProvider);
        }
    }

    public static void properties(JSONWriter jsonWriter, GeopointItem geopointItem, PropertyEligibility propertyEligibility, LangContext langContext, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("geopoint");
        }
        if (propertyEligibility.includeProperty("lat")) {
            jsonWriter.key("lat");
            jsonWriter.value(geopointItem.getLatitude().toString());
        }
        if (propertyEligibility.includeProperty("lon")) {
            jsonWriter.key("lon");
            jsonWriter.value(geopointItem.getLongitude().toString());
        }
        if (propertyEligibility.includeProperty("latlabels")) {
            jsonWriter.key("latlabels");
            FicheItemJson.geoLabelsObject(jsonWriter, geopointItem.getLatitude(), true, langContext, messageLocalisationProvider);
        }
        if (propertyEligibility.includeProperty("lonlabels")) {
            jsonWriter.key("lonlabels");
            FicheItemJson.geoLabelsObject(jsonWriter, geopointItem.getLongitude(), false, langContext, messageLocalisationProvider);
        }
    }

    public static void properties(JSONWriter jsonWriter, LinkItem linkItem, PropertyEligibility propertyEligibility) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("link");
        }
        if (propertyEligibility.includeProperty("href")) {
            jsonWriter.key("href");
            jsonWriter.value(linkItem.getHref());
        }
        if (propertyEligibility.includeProperty("title")) {
            jsonWriter.key("title");
            jsonWriter.value(linkItem.getTitle());
        }
        if (propertyEligibility.includeProperty("comment")) {
            jsonWriter.key("comment");
            jsonWriter.value(linkItem.getComment());
        }
    }

    public static void properties(JSONWriter jsonWriter, ImageItem imageItem, PropertyEligibility propertyEligibility) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("image");
        }
        if (propertyEligibility.includeProperty("src")) {
            jsonWriter.key("src");
            jsonWriter.value(imageItem.getSrc());
        }
        if (propertyEligibility.includeProperty("title")) {
            jsonWriter.key("title");
            jsonWriter.value(imageItem.getTitle());
        }
        if (propertyEligibility.includeProperty("alt")) {
            jsonWriter.key("alt");
            jsonWriter.value(imageItem.getAlt());
        }
    }

    public static void properties(JSONWriter jsonWriter, EmailItem emailItem, PropertyEligibility propertyEligibility) throws IOException {
        EmailCore emailCore = emailItem.getEmailCore();
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("email");
        }
        if (propertyEligibility.includeProperty("complete")) {
            jsonWriter.key("complete");
            jsonWriter.value(emailCore.toCompleteString());
        }
        if (propertyEligibility.includeProperty("address")) {
            jsonWriter.key("address");
            jsonWriter.value(emailCore.getAddrSpec());
        }
        if (propertyEligibility.includeProperty("name")) {
            jsonWriter.key("name");
            jsonWriter.value(emailCore.getRealName());
        }
    }

    public static void properties(JSONWriter jsonWriter, NumberItem numberItem, PropertyEligibility propertyEligibility, LangContext langContext) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("number");
        }
        if (propertyEligibility.includeProperty("code")) {
            jsonWriter.key("code");
            jsonWriter.value(numberItem.getDecimal().toString());
        }
        if (propertyEligibility.includeProperty("labels")) {
            jsonWriter.key("labels");
            FicheItemJson.decimalLabelsObject(jsonWriter, numberItem.getDecimal(), langContext);
        }
    }

    public static void properties(JSONWriter jsonWriter, AmountItem amountItem, PropertyEligibility propertyEligibility, LangContext langContext) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("amount");
        }
        if (propertyEligibility.includeProperty("code")) {
            jsonWriter.key("code");
            jsonWriter.value(amountItem.toString());
        }
        if (propertyEligibility.includeProperty("currency")) {
            jsonWriter.key("currency");
            jsonWriter.value(amountItem.getCurrency().getCurrencyCode());
        }
        if (propertyEligibility.includeProperty("decimal")) {
            jsonWriter.key("decimal");
            jsonWriter.value(amountItem.getDecimal().toString());
        }
        if (propertyEligibility.includeProperty("labels")) {
            jsonWriter.key("labels");
            FicheItemJson.amountLabelsObject(jsonWriter, amountItem.getDecimal(), amountItem.getCurrency(), langContext);
        }
        if (propertyEligibility.includeProperty("long")) {
            jsonWriter.key("long");
            jsonWriter.value(amountItem.toMoneyLong());
        }
    }

    public static void properties(JSONWriter jsonWriter, ParaItem paraItem, PropertyEligibility propertyEligibility) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("para");
        }
        if (propertyEligibility.includeProperty("raw")) {
            jsonWriter.key("para");
            jsonWriter.value(paraItem.contentToString());
        }
    }

    public static void properties(JSONWriter jsonWriter, Item item, PropertyEligibility propertyEligibility) throws IOException {
        if (propertyEligibility.includeProperty("type")) {
            jsonWriter.key("type");
            jsonWriter.value("item");
        }
        jsonWriter.key("value");
        jsonWriter.value(item.getValue());
    }

    public static void dateLabelsObject(JSONWriter jsonWriter, FuzzyDate date, LangContext langContext) throws IOException {
        jsonWriter.object();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle(unit.getFormatLocale());
                jsonWriter.key(unit.getLang().toString());
                jsonWriter.value(date.getDateLitteral(dateFormatBundle));
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle(userLangContext.getFormatLocale());
            jsonWriter.key(userLangContext.getWorkingLang().toString());
            jsonWriter.value(date.getDateLitteral(dateFormatBundle));
        }
        jsonWriter.endObject();
    }

    public static void countryLabelsObject(JSONWriter jsonWriter, Country country, LangContext langContext, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        FicheItemJson.localisationLabelsObject(jsonWriter, country.toString(), langContext, messageLocalisationProvider);
    }

    public static void langLabelsObject(JSONWriter jsonWriter, Lang lang, LangContext langContext, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        FicheItemJson.localisationLabelsObject(jsonWriter, lang.toString(), langContext, messageLocalisationProvider);
    }

    private static void localisationLabelsObject(JSONWriter jsonWriter, String code, LangContext langContext, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        UserLangContext userLangContext;
        MessageLocalisation messageLocalisation;
        String message;
        jsonWriter.object();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang currentLang = unit.getLang();
                MessageLocalisation messageLocalisation2 = messageLocalisationProvider.getMessageLocalisation(currentLang);
                String message2 = messageLocalisation2.toString(code);
                if (message2 == null) continue;
                message2 = StringUtils.getFirstPart(message2);
                jsonWriter.key(currentLang.toString());
                jsonWriter.value(message2);
            }
        } else if (langContext instanceof UserLangContext && (message = (messageLocalisation = messageLocalisationProvider.getMessageLocalisation(userLangContext = (UserLangContext)langContext)).toString(code)) != null) {
            message = StringUtils.getFirstPart(message);
            jsonWriter.key(userLangContext.getWorkingLang().toString());
            jsonWriter.value(message);
        }
        jsonWriter.endObject();
    }

    public static void geoLabelsObject(JSONWriter jsonWriter, DegreDecimal degreDecimal, boolean latitude, LangContext langContext, MessageLocalisationProvider messageLocalisationProvider) throws IOException {
        UserLangContext userLangContext;
        MessageLocalisation messageLocalisation;
        String message;
        DegreSexagesimal sexa = DegreSexagesimal.fromDegreDecimal(degreDecimal);
        String value = sexa.toString(false, " ");
        String code = latitude ? SpecialCodes.getLatitudeSpecialCode(sexa) : SpecialCodes.getLongitudeSpecialCode(sexa);
        jsonWriter.object();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                MessageLocalisation messageLocalisation2 = messageLocalisationProvider.getMessageLocalisation(lang);
                String message2 = messageLocalisation2.toString(code);
                if (message2 == null) continue;
                jsonWriter.key(lang.toString());
                jsonWriter.value(value + message2);
            }
        } else if (langContext instanceof UserLangContext && (message = (messageLocalisation = messageLocalisationProvider.getMessageLocalisation(userLangContext = (UserLangContext)langContext)).toString(code)) != null) {
            jsonWriter.key(userLangContext.getWorkingLang().toString());
            jsonWriter.value(value + message);
        }
        jsonWriter.endObject();
    }

    public static void decimalLabelsObject(JSONWriter jsonWriter, Decimal decimal, LangContext langContext) throws IOException {
        jsonWriter.object();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(unit.getFormatLocale());
                jsonWriter.key(unit.getLang().toString());
                jsonWriter.value(decimal.toString(symbols));
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(userLangContext.getFormatLocale());
            jsonWriter.key(userLangContext.getWorkingLang().toString());
            jsonWriter.value(decimal.toString(symbols));
        }
        jsonWriter.endObject();
    }

    public static void amountLabelsObject(JSONWriter jsonWriter, Decimal decimal, ExtendedCurrency currency, LangContext langContext) throws IOException {
        jsonWriter.object();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(unit.getFormatLocale());
                jsonWriter.key(unit.getLang().toString());
                jsonWriter.value(MoneyUtils.toLitteralString(decimal, currency, symbols));
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(userLangContext.getFormatLocale());
            jsonWriter.key(userLangContext.getWorkingLang().toString());
            jsonWriter.value(MoneyUtils.toLitteralString(decimal, currency, symbols));
        }
        jsonWriter.endObject();
    }
}

