/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.impl.CroisementImpl;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesCache;

abstract class AbstractSubsetItem
implements SubsetItem {
    private final Map<SubsetKey, InternalCroisements> croisementsMap = new HashMap<SubsetKey, InternalCroisements>();
    private AttributesCache attributesCache = null;

    AbstractSubsetItem() {
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributesCache == null) {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
        return this.attributesCache.getAttributes();
    }

    protected synchronized boolean innerRemoveAttribute(AttributeKey attributeKey) {
        if (this.attributesCache == null) {
            return false;
        }
        boolean done = this.attributesCache.removeAttribute(attributeKey);
        if (done) {
            this.fireAttributeChange();
        }
        return done;
    }

    protected synchronized boolean innerPutAttribute(Attribute attribute) {
        boolean done;
        if (this.attributesCache == null) {
            this.attributesCache = new AttributesCache();
        }
        if (done = this.attributesCache.putAttribute(attribute)) {
            this.fireAttributeChange();
        }
        return done;
    }

    void fireAttributeChange() {
    }

    @Override
    public Croisements getCroisements(Subset subset) {
        InternalCroisements croisements = this.croisementsMap.get(subset.getSubsetKey());
        if (croisements == null) {
            return CroisementUtils.EMPTY_CROISEMENTS;
        }
        return croisements.getCache();
    }

    void link(SubsetItem otherSubsetItem, CroisementImpl croisement) {
        SubsetKey otherSubsetKey = otherSubsetItem.getSubsetKey();
        InternalCroisements croisements = this.croisementsMap.get(otherSubsetKey);
        if (croisements == null) {
            croisements = new InternalCroisements();
            this.croisementsMap.put(otherSubsetKey, croisements);
        }
        croisements.add(otherSubsetItem, croisement);
    }

    void unlink(SubsetItem otherSubsetItem, CroisementImpl implCroisement) {
        SubsetKey otherSubsetKey = otherSubsetItem.getSubsetKey();
        InternalCroisements croisements = this.croisementsMap.get(otherSubsetKey);
        if (croisements != null) {
            croisements.remove(implCroisement);
        }
    }

    boolean hasCroisement() {
        if (this.croisementsMap.isEmpty()) {
            return false;
        }
        for (InternalCroisements croisements : this.croisementsMap.values()) {
            if (croisements.entryList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static class InternalCroisements {
        private final List<Croisements.Entry> entryList = new ArrayList<Croisements.Entry>();
        private Croisements cache;

        private InternalCroisements() {
        }

        private Croisements getCache() {
            Croisements result = this.cache;
            if (result == null) {
                result = this.initCache();
            }
            return result;
        }

        private synchronized void add(SubsetItem subsetItem, Croisement croisement) {
            this.entryList.add(CroisementUtils.toEntry(subsetItem, croisement));
            this.clearCache();
        }

        private synchronized void remove(CroisementImpl implCroisement) {
            int size = this.entryList.size();
            for (int i = 0; i < size; ++i) {
                if (!this.entryList.get(i).getCroisement().equals(implCroisement)) continue;
                this.entryList.remove(i);
                this.clearCache();
                break;
            }
        }

        private void clearCache() {
            this.cache = null;
        }

        private synchronized Croisements initCache() {
            Croisements newCache;
            if (this.cache != null) {
                return this.cache;
            }
            this.cache = newCache = CroisementUtils.toCroisements(this.entryList);
            return newCache;
        }
    }
}

