/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.subsettree.CroisementSubsetNode;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.tools.subsettree.CroisementSubsetNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.GroupNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.NodeListBuilder;
import fr.exemole.bdfserver.tools.subsettree.SubsetTreeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.permission.PermissionSummary;

public final class TreeFilterEngine {
    private TreeFilterEngine() {
    }

    public static SubsetTree admin(PermissionSummary permissionSummary, SubsetTree subsetTree) {
        if (TreeFilterEngine.isUnchanged(permissionSummary, subsetTree)) {
            return subsetTree;
        }
        return TreeFilterEngine.filterSubsetTree(new AdminTest(permissionSummary), subsetTree);
    }

    public static SubsetTree read(PermissionSummary permissionSummary, SubsetTree subsetTree) {
        if (TreeFilterEngine.isUnchanged(permissionSummary, subsetTree)) {
            return subsetTree;
        }
        return TreeFilterEngine.filterSubsetTree(new ReadTest(permissionSummary), subsetTree);
    }

    public static SubsetTree selection(Set<SubsetKey> subsetKeySet, SubsetTree subsetTree) {
        if (subsetTree.getNodeList().isEmpty()) {
            return subsetTree;
        }
        SelectionTest test = new SelectionTest(subsetKeySet);
        return TreeFilterEngine.filterSubsetTree(test, subsetTree);
    }

    public static SubsetTree selection(SubsetEligibility subsetEligibility, SubsetTree subsetTree) {
        if (subsetTree.getNodeList().isEmpty()) {
            return subsetTree;
        }
        SubsetEligibilityTest test = new SubsetEligibilityTest(subsetEligibility);
        return TreeFilterEngine.filterSubsetTree(test, subsetTree);
    }

    public static SubsetTree croisement(SubsetItem subsetItem, SubsetTree subsetTree) {
        CroisementTreeBuilder croisementTreeBuilder = new CroisementTreeBuilder(subsetItem);
        return croisementTreeBuilder.filter(subsetTree);
    }

    private static boolean isUnchanged(PermissionSummary permissionSummary, SubsetTree subsetTree) {
        if (subsetTree.getNodeList().isEmpty()) {
            return true;
        }
        return permissionSummary.isFichothequeAdmin();
    }

    private static SubsetTree filterSubsetTree(Test test, SubsetTree origin) {
        ArrayList<SubsetTree.Node> destinationList = new ArrayList<SubsetTree.Node>();
        for (SubsetTree.Node node : origin.getNodeList()) {
            GroupNode result;
            if (node instanceof SubsetNode) {
                SubsetNode subsetNode = (SubsetNode)node;
                if (!test.contains(subsetNode.getSubsetKey())) continue;
                destinationList.add(subsetNode);
                continue;
            }
            if (!(node instanceof GroupNode) || (result = TreeFilterEngine.filterGroupNode(test, (GroupNode)node)).getSubnodeList().isEmpty()) continue;
            destinationList.add(result);
        }
        return SubsetTreeBuilder.build(destinationList);
    }

    private static GroupNode filterGroupNode(Test test, GroupNode origin) {
        GroupNodeBuilder builder = new GroupNodeBuilder(origin.getName(), true);
        for (SubsetTree.Node subnode : origin.getSubnodeList()) {
            GroupNode result;
            if (subnode instanceof SubsetNode) {
                SubsetNode subsetNode = (SubsetNode)subnode;
                if (!test.contains(subsetNode.getSubsetKey())) continue;
                builder.addSubsetNode(subsetNode);
                continue;
            }
            if (!(subnode instanceof GroupNode) || (result = TreeFilterEngine.filterGroupNode(test, (GroupNode)subnode)).getSubnodeList().isEmpty()) continue;
            builder.addGroupNode(result);
        }
        return builder.toGroupNode();
    }

    private static class AdminTest
    extends Test {
        private final PermissionSummary permissionSummary;

        private AdminTest(PermissionSummary permissionSummary) {
            this.permissionSummary = permissionSummary;
        }

        @Override
        public boolean contains(SubsetKey subsetKey) {
            return this.permissionSummary.isSubsetAdmin(subsetKey);
        }
    }

    private static abstract class Test {
        private Test() {
        }

        public abstract boolean contains(SubsetKey var1);
    }

    private static class ReadTest
    extends Test {
        private final PermissionSummary permissionSummary;

        private ReadTest(PermissionSummary permissionSummary) {
            this.permissionSummary = permissionSummary;
        }

        @Override
        public boolean contains(SubsetKey subsetKey) {
            return this.permissionSummary.hasAccess(subsetKey);
        }
    }

    private static class SelectionTest
    extends Test {
        private final Set<SubsetKey> subsetKeySet;

        private SelectionTest(Set<SubsetKey> subsetKeySet) {
            this.subsetKeySet = subsetKeySet;
        }

        @Override
        public boolean contains(SubsetKey subsetKey) {
            return this.subsetKeySet.contains(subsetKey);
        }
    }

    private static class SubsetEligibilityTest
    extends Test {
        private final SubsetEligibility subsetEligibility;

        private SubsetEligibilityTest(SubsetEligibility subsetEligibility) {
            this.subsetEligibility = subsetEligibility;
        }

        @Override
        public boolean contains(SubsetKey subsetKey) {
            return this.subsetEligibility.accept(subsetKey);
        }
    }

    private static class CroisementTreeBuilder {
        private final SubsetItem subsetItem;
        private final Fichotheque fichotheque;

        private CroisementTreeBuilder(SubsetItem subsetItem) {
            this.subsetItem = subsetItem;
            this.fichotheque = subsetItem.getFichotheque();
        }

        private SubsetTree filter(SubsetTree subsetTree) {
            SubsetTreeBuilder subsetTreeBuilder = new SubsetTreeBuilder(true);
            this.filter(subsetTreeBuilder, subsetTree.getNodeList());
            return subsetTreeBuilder.toSubsetTree();
        }

        private void filter(NodeListBuilder nodeListBuilder, List<SubsetTree.Node> nodeList) {
            for (SubsetTree.Node node : nodeList) {
                if (node instanceof SubsetNode) {
                    CroisementSubsetNode croisementSubsetNode = this.convert((SubsetNode)node);
                    if (croisementSubsetNode == null) continue;
                    nodeListBuilder.addSubsetNode(croisementSubsetNode);
                    continue;
                }
                if (!(node instanceof GroupNode)) continue;
                GroupNode groupNode = (GroupNode)node;
                GroupNodeBuilder builder = new GroupNodeBuilder(groupNode.getName(), true);
                this.filter(builder, groupNode.getSubnodeList());
                nodeListBuilder.addGroupNode(builder.toGroupNode());
            }
        }

        private CroisementSubsetNode convert(SubsetNode subsetNode) {
            Subset subset = this.fichotheque.getSubset(subsetNode.getSubsetKey());
            if (subset == null) {
                return null;
            }
            Croisements croisements = this.fichotheque.getCroisements(this.subsetItem, subset);
            if (croisements.isEmpty()) {
                return null;
            }
            return CroisementSubsetNodeBuilder.build(subset, croisements);
        }
    }
}

