/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders;

import fr.exemole.bdfserver.api.ficheform.AddendaIncludeElement;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.L10nUtils;
import java.util.Collection;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.AddendaUtils;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;

public class AddendaIncludeElementBuilder {
    private final String name;
    private final Addenda addenda;
    private String label = "";
    private boolean mandatory = false;
    private boolean addAllowed = false;
    private Collection<Liaison> liaisons = CroisementUtils.EMPTY_LIAISONLIST;
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;

    public AddendaIncludeElementBuilder(String name, Addenda addenda) {
        this.name = name;
        this.addenda = addenda;
    }

    public AddendaIncludeElementBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public AddendaIncludeElementBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public AddendaIncludeElementBuilder setLiaisons(Collection<Liaison> liaisons) {
        this.liaisons = liaisons == null ? CroisementUtils.EMPTY_LIAISONLIST : liaisons;
        return this;
    }

    public AddendaIncludeElementBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public AddendaIncludeElementBuilder setAddAllowed(boolean addAllowed) {
        this.addAllowed = addAllowed;
        return this;
    }

    public AddendaIncludeElement toAddendaIncludeElement() {
        int size = this.liaisons.size();
        Document[] documentArray = new Document[size];
        int p = 0;
        for (Liaison liaison : this.liaisons) {
            documentArray[p] = (Document)liaison.getSubsetItem();
            ++p;
        }
        return new InternalAddendaIncludeElement(this.name, this.addenda, this.label, this.mandatory, this.attributes, AddendaUtils.wrap(documentArray), this.addAllowed);
    }

    @Nullable
    public static AddendaIncludeElementBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SubsetIncludeUi includeUi) {
        ExtendedIncludeKey includeKey = includeUi.getExtendedIncludeKey();
        SubsetKey addendaKey = includeKey.getSubsetKey();
        Addenda addenda = (Addenda)ficheFormParameters.getBdfServer().getFichotheque().getSubset(addendaKey);
        if (addenda == null) {
            return null;
        }
        boolean addAllowed = ficheFormParameters.getPermissionSummary().isSubsetAdmin(addendaKey);
        Collection<Liaison> liaisons = fichePointeur.getLiaisons(addenda, includeKey);
        if (liaisons.isEmpty() && includeUi.isObsolete()) {
            return null;
        }
        return AddendaIncludeElementBuilder.init(includeUi.getName(), addenda).setLiaisons(liaisons).setLabel(L10nUtils.toLabelString(ficheFormParameters, includeUi)).setAddAllowed(addAllowed).setAttributes(includeUi.getAttributes());
    }

    public static AddendaIncludeElementBuilder init(String name, Addenda addenda) {
        return new AddendaIncludeElementBuilder(name, addenda);
    }

    private static class InternalAddendaIncludeElement
    implements AddendaIncludeElement {
        private final String name;
        private final Addenda addenda;
        private final String label;
        private final boolean mandatory;
        private final boolean addAllowed;
        private final Attributes attributes;
        private final List<Document> documentList;

        private InternalAddendaIncludeElement(String name, Addenda addenda, String label, boolean mandatory, Attributes attributes, List<Document> documentList, boolean addAllowed) {
            this.name = name;
            this.addenda = addenda;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.documentList = documentList;
            this.addAllowed = addAllowed;
        }

        @Override
        public String getIncludeName() {
            return this.name;
        }

        @Override
        public Addenda getAddenda() {
            return this.addenda;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public boolean isAddAllowed() {
            return this.addAllowed;
        }

        @Override
        public List<Document> getDocumentList() {
            return this.documentList;
        }
    }
}

