/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.compilers;

import fr.exemole.bdfserver.tools.exportation.transformation.compilers.PropertyPart;
import net.fichotheque.album.Illustration;

class FrameDim {
    private String width;
    private String height;

    private FrameDim(float w, float h) {
        this.width = String.valueOf(w) + "cm";
        this.height = String.valueOf(h) + "cm";
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    static FrameDim build(Illustration illustration, PropertyPart propertyPart) {
        float width = FrameDim.get(propertyPart, "width");
        float height = FrameDim.get(propertyPart, "height");
        float ratio = FrameDim.getRatio(illustration);
        if (width <= 0.0f) {
            if (height <= 0.0f) {
                height = 1.0f;
                width = ratio;
            } else {
                width = height * ratio;
            }
        } else if (height <= 0.0f) {
            height = width / ratio;
        }
        return new FrameDim(width, height);
    }

    static float get(PropertyPart propertyPart, String optionName) {
        String optionValue = propertyPart.getOptionValue(optionName);
        if (optionValue == null) {
            return -1.0f;
        }
        try {
            float value = Float.valueOf(optionValue).floatValue();
            return value;
        }
        catch (NumberFormatException nfe) {
            return -1.0f;
        }
    }

    static float getRatio(Illustration illustration) {
        return (float)illustration.getOriginalWidth() / (float)illustration.getOriginalHeight();
    }
}

