/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation;

import fr.exemole.bdfserver.api.exportation.transformation.StreamTemplateFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.fichotheque.exportation.transformation.StreamTemplate;
import net.fichotheque.extraction.def.ExtractionDef;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.exceptions.NestedTransformerException;
import net.mapeadores.util.io.StreamTransformer;

public class XsltStreamTemplateFactory
implements StreamTemplateFactory {
    private final Attributes attributes;
    private final ExtractionDef customExtractionDef;
    private final StreamTransformer streamTransformer;

    public XsltStreamTemplateFactory(Attributes attributes, ExtractionDef customExtractionDef, StreamTransformer streamTransformer) {
        this.attributes = attributes;
        this.streamTransformer = streamTransformer;
        this.customExtractionDef = customExtractionDef;
    }

    @Override
    public StreamTemplate.Xslt newInstance() {
        return new XsltStreamTemplate(this.attributes, this.customExtractionDef, this.streamTransformer);
    }

    private static class XsltStreamTemplate
    implements StreamTemplate.Xslt {
        private final Attributes attributes;
        private final ExtractionDef customExtractionDef;
        private final StreamTransformer streamTransformer;

        public XsltStreamTemplate(Attributes attributes, ExtractionDef customExtractionDef, StreamTransformer streamTransformer) {
            this.attributes = attributes;
            this.customExtractionDef = customExtractionDef;
            this.streamTransformer = streamTransformer;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public ExtractionDef getCustomExtractionDef() {
            return this.customExtractionDef;
        }

        @Override
        public String getMimeType() {
            return this.streamTransformer.getMimeType();
        }

        @Override
        public void transform(String extractionString, OutputStream outputStream, Map<String, Object> transformerParameters, Map<String, String> outputProperties) throws IOException {
            StreamSource xmlSource = new StreamSource(new StringReader(extractionString));
            try {
                this.streamTransformer.transform(xmlSource, outputStream, transformerParameters, outputProperties);
            }
            catch (TransformerException te) {
                throw new NestedTransformerException(te);
            }
        }
    }
}

