/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;

public class BalayageLog
implements AutoCloseable,
JsonProperty {
    public static final String UNRESOLVED_PATH = "unresolvedPath";
    public static final String WRONG_PATTERN = "wrongPattern";
    public static final String NO_OUTPUT = "noOutput";
    public static final String EXTRACTION_NOT_FOUND = "extractionNotFound";
    public static final String EXTRACTION_EXCEPTION = "extractionException";
    public static final String OUTPUTPATH_EXCEPTION = "outputPathException";
    public static final String TRANSFORMER_NOT_FOUND = "transformerNotFound";
    public static final String TRANSFORMER_EXCEPTION = "transformerException";
    public static final String NO_XSLTPATH = "noXsltPath";
    public static final String WRONG_PATH = "wrongPath";
    public static final String TRANSFORMATION_EXCEPTION = "transformerExceptionDuringTransformation";
    public static final String IO_EXCEPTION = "ioException";
    public static final String COMMANDCHECK_EXCEPTION = "commandCheck";
    public static final String COMMANDIO_EXCEPTION = "commandIOException";
    public static final String COMMANDINTERRUPTED_EXCEPTION = "commandInterruptedException";
    public static final String UNKNOWN_NAME = "unknownName";
    public static final String SQLEXPORT_ERROR = "sqlExportError";
    public static final String EXTRACTION_ATTRIBUTE = "extraction";
    public static final String SITEMAP_KEY = "sitemap";
    public static final String COMMAND_KEY = "command";
    public static final String SCRUTARIEXPORT_KEY = "scrutariexport";
    public static final String SQLEXPORT_KEY = "sqlexport";
    private static final DecimalFormat SecondFormat = new DecimalFormat("0.000");
    private final String balayageName;
    private final List<LogItem> logList;
    private final PrintWriter fileWriter;
    private long runStartTime;
    private long previousTime;
    private UnitInfo currentUnitInfo;
    private boolean hasError = false;

    public BalayageLog(String balayageName, File logFile) {
        PrintWriter pw;
        this.balayageName = balayageName;
        this.logList = new ArrayList<LogItem>();
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), "UTF-8"));
        }
        catch (IOException ioe) {
            pw = null;
        }
        this.fileWriter = pw;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void addBalayageUnitLog(int balayageUnitIndex, BalayageUnit balayageUnit) {
        this.getDuration();
        UnitInfo unitInfo = new UnitInfo(balayageUnitIndex, BalayageLog.toBalayageUnitPath(balayageUnit));
        this.add(new BalayageUnitStart(unitInfo));
        this.currentUnitInfo = unitInfo;
    }

    public void addBalayageUnitError(int balayageUnitIndex, BalayageUnit balayageUnit, String errorType, String value, String message) {
        this.getDuration();
        this.hasError = true;
        this.add(new BalayageUnitError(balayageUnitIndex, BalayageLog.toBalayageUnitPath(balayageUnit), errorType, value, message));
    }

    public void addOutputError(int balayageUnitIndex, int outputIndex, BalayageOutput output, String errorType, String value, String message) {
        this.getDuration(balayageUnitIndex);
        this.hasError = true;
        this.add(new OutputError(balayageUnitIndex, BalayageLog.toBalayageUnitPath(output.getBalayageUnit()), outputIndex, errorType, value, message));
    }

    public void addPostscriptumLog(String postscriptumType, String name) {
        long duration = this.getDuration();
        this.add(new PostscriptumLog(postscriptumType, name, duration));
    }

    public void addPostscriptumError(String postscriptumType, String name, String errorType, String message) {
        this.getDuration();
        this.hasError = true;
        this.add(new PostscriptumError(postscriptumType, name, errorType, message));
    }

    public void addFileGeneration(int balayageUnitIndex, int outputIndex, File f) {
        long duration = this.getDuration(balayageUnitIndex);
        FileGeneration logItem = new FileGeneration(balayageUnitIndex, outputIndex, f, duration);
        this.printToFile(logItem);
    }

    public void runStarted() {
        this.previousTime = this.runStartTime = System.currentTimeMillis();
    }

    public void runEnded() {
        long duration = this.getDuration();
        this.add(new End(System.currentTimeMillis() - this.runStartTime));
    }

    private void printToFile(LogItem logItem) {
        if (this.fileWriter != null) {
            logItem.print(this.fileWriter);
        }
    }

    private long getDuration() {
        return this.getDuration(-1);
    }

    private long getDuration(int balayageUnitIndex) {
        long currentTime = System.currentTimeMillis();
        long duration = currentTime - this.previousTime;
        this.previousTime = currentTime;
        if (this.currentUnitInfo != null && this.currentUnitInfo.index != balayageUnitIndex) {
            long unitDuration = currentTime - this.currentUnitInfo.startTime;
            this.add(new BalayageUnitEnd(this.currentUnitInfo, unitDuration));
            this.currentUnitInfo = null;
        }
        return duration;
    }

    private void add(LogItem logItem) {
        this.logList.add(logItem);
        this.printToFile(logItem);
    }

    @Override
    public void close() {
        if (this.fileWriter != null) {
            this.fileWriter.close();
        }
    }

    public void printLog(PrintWriter pw) {
        for (LogItem logItem : this.logList) {
            logItem.print(pw);
        }
    }

    @Override
    public String getName() {
        return "balayageLog";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        jw.object();
        jw.key("balayageName").value(this.balayageName);
        jw.key("itemArray");
        jw.array();
        for (LogItem logItem : this.logList) {
            jw.object();
            jw.key("type").value(logItem.getType());
            logItem.properties(jw);
            jw.endObject();
        }
        jw.endArray();
        jw.endObject();
    }

    private static void printTime(PrintWriter pw, long time) {
        float f = (float)time / 1000.0f;
        pw.print(String.valueOf(f));
        pw.print("s");
    }

    private static String toBalayageUnitPath(BalayageUnit balayageUnit) {
        StringBuilder buf = new StringBuilder();
        buf.append(balayageUnit.getType());
        String extractionPath = balayageUnit.getExtractionPath();
        if (!extractionPath.isEmpty()) {
            buf.append("/");
            buf.append(extractionPath);
        }
        return buf.toString();
    }

    private static void writeDuration(JSONWriter jw, long duration) throws IOException {
        jw.key("duration").value(SecondFormat.format((double)duration / 1000.0));
    }

    private static void writeUnit(JSONWriter jw, int number, String path) throws IOException {
        jw.key("unit");
        jw.object();
        jw.key("number").value(number);
        jw.key("path").value(path);
        jw.endObject();
    }

    private static void writePostscriptum(JSONWriter jw, String type, String name) throws IOException {
        jw.key("postscriptum");
        jw.object();
        jw.key("type").value(type);
        jw.key("name").value(name);
        jw.endObject();
    }

    private static void writeError(JSONWriter jw, String errorType, @Nullable String value, @Nullable String message) throws IOException {
        jw.key("error");
        jw.object();
        jw.key("type").value(errorType);
        if (value != null) {
            jw.key("value").value(value);
        }
        if (message != null) {
            jw.key("message").value(message);
        }
        jw.endObject();
    }

    private static class UnitInfo {
        private final int index;
        private final int number;
        private final String path;
        private final long startTime;

        private UnitInfo(int index, String path) {
            this.index = index;
            this.number = index + 1;
            this.path = path;
            this.startTime = System.currentTimeMillis();
        }

        private void write(JSONWriter jw) throws IOException {
            BalayageLog.writeUnit(jw, this.number, this.path);
        }
    }

    private static class BalayageUnitStart
    extends LogItem {
        private final UnitInfo unitInfo;
        private final int freeMemory;

        private BalayageUnitStart(UnitInfo unitInfo) {
            this.unitInfo = unitInfo;
            this.freeMemory = (int)Math.floor((double)Runtime.getRuntime().freeMemory() / 1048576.0);
        }

        @Override
        public String getType() {
            return "balayage-unit-start";
        }

        @Override
        public void print(PrintWriter pw) {
            pw.println("");
            pw.print("+------- ");
            pw.print("balayageUnit ");
            pw.print(this.unitInfo.number);
            pw.print(": ");
            pw.print(this.unitInfo.path);
            pw.println(") / mem = " + this.freeMemory);
        }

        @Override
        public void properties(JSONWriter jw) throws IOException {
            this.unitInfo.write(jw);
        }
    }

    private static abstract class LogItem {
        private LogItem() {
        }

        public abstract String getType();

        public abstract void print(PrintWriter var1);

        public abstract void properties(JSONWriter var1) throws IOException;
    }

    private static class BalayageUnitError
    extends LogItem {
        private final int balayageUnitIndex;
        private final String balayageUnitPath;
        private final String message;
        private final String errorType;
        private final String value;

        private BalayageUnitError(int balayageUnitIndex, String balayageUnitPath, String errorType, String value, String message) {
            this.balayageUnitIndex = balayageUnitIndex;
            this.message = message;
            this.errorType = errorType;
            this.value = value;
            this.balayageUnitPath = balayageUnitPath;
        }

        @Override
        public String getType() {
            return "balayage-unit-error";
        }

        @Override
        public void print(PrintWriter pw) {
            pw.println("");
            pw.print("[! ");
            pw.print(this.errorType);
            pw.print(" !] ");
            pw.print("balayageUnit ");
            pw.print(this.balayageUnitIndex + 1);
            pw.print(": ");
            pw.print(this.balayageUnitPath);
            if (this.value != null) {
                pw.print(", value: ");
                pw.print(this.value);
            }
            if (this.message != null) {
                pw.print(", message: ");
                pw.print(this.message);
            }
            pw.println("");
        }

        @Override
        public void properties(JSONWriter jw) throws IOException {
            BalayageLog.writeUnit(jw, this.balayageUnitIndex + 1, this.balayageUnitPath);
            BalayageLog.writeError(jw, this.errorType, this.value, this.message);
        }
    }

    private static class OutputError
    extends LogItem {
        private final int balayageUnitIndex;
        private final String balayageUnitPath;
        private final int outputIndex;
        private final String errorType;
        private final String message;
        private final String value;

        private OutputError(int balayageUnitIndex, String balayageUnitPath, int outputIndex, String errorType, String value, String message) {
            this.balayageUnitIndex = balayageUnitIndex;
            this.outputIndex = outputIndex;
            this.message = message;
            this.errorType = errorType;
            this.value = value;
            this.balayageUnitPath = balayageUnitPath;
        }

        @Override
        public String getType() {
            return "output-error";
        }

        @Override
        public void print(PrintWriter pw) {
            pw.println("");
            pw.print("[! ");
            pw.print(this.errorType);
            pw.print(" !] ");
            pw.print("balayageUnit ");
            pw.print(this.balayageUnitIndex + 1);
            pw.print(": ");
            pw.print(this.balayageUnitPath);
            pw.print(", output: ");
            pw.print(this.outputIndex + 1);
            if (this.value != null) {
                pw.print(", value: ");
                pw.print(this.value);
            }
            if (this.message != null) {
                pw.print(", message: ");
                pw.print(this.message);
            }
            pw.println("");
        }

        @Override
        public void properties(JSONWriter jw) throws IOException {
            BalayageLog.writeUnit(jw, this.balayageUnitIndex + 1, this.balayageUnitPath);
            jw.key("output").value(this.outputIndex + 1);
            BalayageLog.writeError(jw, this.errorType, this.value, this.message);
        }
    }

    private static class PostscriptumLog
    extends LogItem {
        private final String type;
        private final String name;
        private final long duration;

        private PostscriptumLog(String type, String name, long duration) {
            this.type = type;
            this.name = name;
            this.duration = duration;
        }

        @Override
        public String getType() {
            return "postscriptum-log";
        }

        @Override
        public void print(PrintWriter pw) {
            pw.println("");
            pw.print("+------- ");
            pw.print(this.type);
            pw.print(": ");
            pw.println(this.name);
        }

        @Override
        public void properties(JSONWriter jw) throws IOException {
            BalayageLog.writePostscriptum(jw, this.type, this.name);
            BalayageLog.writeDuration(jw, this.duration);
        }
    }

    private static class PostscriptumError
    extends LogItem {
        private final String postscriptumType;
        private final String name;
        private final String errorType;
        private final String message;

        private PostscriptumError(String postscriptumType, String name, String errorType, String message) {
            this.postscriptumType = postscriptumType;
            this.name = name;
            this.errorType = errorType;
            this.message = message;
        }

        @Override
        public String getType() {
            return "postscriptum-error";
        }

        @Override
        public void print(PrintWriter pw) {
            pw.println("");
            pw.print("[! ");
            pw.print(this.postscriptumType);
            pw.print(": ");
            pw.print(this.errorType);
            pw.print(" !] ");
            pw.print(this.message);
            pw.println("");
        }

        @Override
        public void properties(JSONWriter jw) throws IOException {
            BalayageLog.writePostscriptum(jw, this.postscriptumType, this.name);
            BalayageLog.writeError(jw, this.errorType, null, this.message);
        }
    }

    private static class FileGeneration
    extends LogItem {
        private final int balayageUnitIndex;
        private final int outputIndex;
        private final String path;
        private final long duration;
        private final int freeMemory;

        private FileGeneration(int balayageUnitIndex, int outputIndex, File f, long duration) {
            this.balayageUnitIndex = balayageUnitIndex;
            this.outputIndex = outputIndex;
            this.duration = duration;
            this.path = f.getAbsolutePath();
            this.freeMemory = (int)Math.floor((double)Runtime.getRuntime().freeMemory() / 1048576.0);
        }

        @Override
        public String getType() {
            return "file-generation";
        }

        @Override
        public void print(PrintWriter pw) {
            pw.print("out: ");
            pw.print(this.balayageUnitIndex + 1);
            pw.print(".");
            pw.print(this.outputIndex + 1);
            pw.print(" path: ");
            pw.print(this.path);
            pw.print(" (");
            BalayageLog.printTime(pw, this.duration);
            pw.println(") / mem = " + this.freeMemory);
        }

        @Override
        public void properties(JSONWriter jw) throws IOException {
            StringBuilder buf = new StringBuilder();
            buf.append(this.balayageUnitIndex + 1);
            buf.append(".");
            buf.append(this.outputIndex + 1);
            jw.key("step").value(buf.toString());
            jw.key("path").value(this.path);
            BalayageLog.writeDuration(jw, this.duration);
        }
    }

    private static class End
    extends LogItem {
        private final long duration;

        private End(long duration) {
            this.duration = duration;
        }

        @Override
        public String getType() {
            return "end";
        }

        @Override
        public void print(PrintWriter pw) {
            pw.println("");
            pw.print("===== Generation time  : ");
            BalayageLog.printTime(pw, this.duration);
            pw.println("");
        }

        @Override
        public void properties(JSONWriter jw) throws IOException {
            jw.key("duration").value(this.duration);
        }
    }

    private static class BalayageUnitEnd
    extends LogItem {
        private final UnitInfo unitInfo;
        private final long duration;

        private BalayageUnitEnd(UnitInfo unitInfo, long duration) {
            this.unitInfo = unitInfo;
            this.duration = duration;
        }

        @Override
        public String getType() {
            return "balayage-unit-end";
        }

        @Override
        public void print(PrintWriter pw) {
            pw.print("+------- ");
            pw.print(this.unitInfo.number);
            pw.print(" / ");
            BalayageLog.printTime(pw, this.duration);
            pw.println("");
        }

        @Override
        public void properties(JSONWriter jw) throws IOException {
            this.unitInfo.write(jw);
            BalayageLog.writeDuration(jw, this.duration);
        }
    }
}

