/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.jdbm;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.storage.directory.jdbm.SubsetItemRecordId;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.helper.Serializer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.io.output.ByteArrayOutputStream;

public class SubsetItemRecordIdMap {
    private static final ClassSerializer classSerializer = new ClassSerializer();
    private final Map<SubsetKey, Map<Integer, SubsetItemRecordId>> globalMap = new HashMap<SubsetKey, Map<Integer, SubsetItemRecordId>>();
    private boolean withChange = false;

    public SubsetItemRecordId getRecordId(SubsetItem subsetItem) {
        return this.getRecordId(subsetItem.getSubset(), subsetItem.getId());
    }

    public SubsetItemRecordId getRecordId(Subset subset, int id) {
        Map<Integer, SubsetItemRecordId> map = this.globalMap.get(subset.getSubsetKey());
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    public Map<Integer, SubsetItemRecordId> getSubsetItemMap(Subset subset) {
        return this.globalMap.get(subset.getSubsetKey());
    }

    public SubsetItemRecordId removeSubsetItem(Subset subset, int id) {
        Map<Integer, SubsetItemRecordId> map = this.globalMap.get(subset.getSubsetKey());
        if (map == null) {
            return null;
        }
        this.withChange = true;
        return map.remove(id);
    }

    public void add(Subset subset, int id, long recid) {
        Map<Integer, SubsetItemRecordId> map = this.globalMap.get(subset.getSubsetKey());
        if (map == null) {
            map = new HashMap<Integer, SubsetItemRecordId>();
            this.globalMap.put(subset.getSubsetKey(), map);
        }
        map.put(id, new SubsetItemRecordId(recid));
        this.withChange = true;
    }

    public void add(Subset subset, int id, long recid1, long recid2) {
        Map<Integer, SubsetItemRecordId> map = this.globalMap.get(subset.getSubsetKey());
        if (map == null) {
            map = new HashMap<Integer, SubsetItemRecordId>();
            this.globalMap.put(subset.getSubsetKey(), map);
        }
        map.put(id, new SubsetItemRecordId(recid1, recid2));
        this.withChange = true;
    }

    private void add(SubsetKey subsetKey, Map<Integer, SubsetItemRecordId> subsetMap) {
        this.globalMap.put(subsetKey, subsetMap);
    }

    private byte[] serialize() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(output);
        dataOutput.writeInt(this.globalMap.size());
        for (Map.Entry<SubsetKey, Map<Integer, SubsetItemRecordId>> entry : this.globalMap.entrySet()) {
            dataOutput.writeUTF(entry.getKey().getKeyString());
            Map<Integer, SubsetItemRecordId> subsetMap = entry.getValue();
            dataOutput.writeInt(subsetMap.size());
            for (Map.Entry<Integer, SubsetItemRecordId> itemEntry : subsetMap.entrySet()) {
                dataOutput.writeInt(itemEntry.getKey());
                SubsetItemRecordId id = itemEntry.getValue();
                byte b = id.getType();
                dataOutput.writeByte(b);
                dataOutput.writeLong(id.getRecid1());
                if (b != 2) continue;
                dataOutput.writeLong(id.getRecid2());
            }
        }
        dataOutput.flush();
        return output.toByteArray();
    }

    public boolean isWithChange() {
        return this.withChange;
    }

    public void save(RecordManager recordManager, String objectName) throws IOException {
        long recordId = recordManager.getNamedObject(objectName);
        recordManager.update(recordId, (Object)this, (Serializer)classSerializer);
        this.withChange = false;
    }

    public static SubsetItemRecordIdMap init(RecordManager recordManager, String objectName) throws IOException {
        long recordId = recordManager.getNamedObject(objectName);
        if (recordId == 0L) {
            SubsetItemRecordIdMap subsetItemRecordIdMap = new SubsetItemRecordIdMap();
            recordId = recordManager.insert((Object)subsetItemRecordIdMap, (Serializer)classSerializer);
            recordManager.setNamedObject(objectName, recordId);
            return subsetItemRecordIdMap;
        }
        SubsetItemRecordIdMap subsetItemRecordIdMap = (SubsetItemRecordIdMap)recordManager.fetch(recordId, (Serializer)classSerializer);
        return subsetItemRecordIdMap;
    }

    private static class ClassSerializer
    implements Serializer {
        private ClassSerializer() {
        }

        public byte[] serialize(Object obj) throws IOException {
            SubsetItemRecordIdMap subsetItemRecordIdMap = (SubsetItemRecordIdMap)obj;
            return subsetItemRecordIdMap.serialize();
        }

        public Object deserialize(byte[] serialized) {
            ByteArrayInputStream input = new ByteArrayInputStream(serialized);
            DataInputStream dataInput = new DataInputStream(input);
            try {
                SubsetItemRecordIdMap subsetItemRecordIdMap = new SubsetItemRecordIdMap();
                int size = dataInput.readInt();
                for (int i = 0; i < size; ++i) {
                    String subsetKeyString = dataInput.readUTF();
                    SubsetKey subsetKey = SubsetKey.parse(subsetKeyString);
                    int subsetSize = dataInput.readInt();
                    HashMap<Integer, SubsetItemRecordId> map = new HashMap<Integer, SubsetItemRecordId>();
                    for (int j = 0; j < subsetSize; ++j) {
                        int id = dataInput.readInt();
                        byte type = dataInput.readByte();
                        long recid1 = dataInput.readLong();
                        if (type == 2) {
                            long recid2 = dataInput.readLong();
                            map.put(id, new SubsetItemRecordId(recid1, recid2));
                            continue;
                        }
                        map.put(id, new SubsetItemRecordId(recid1));
                    }
                    subsetItemRecordIdMap.add(subsetKey, map);
                }
                return subsetItemRecordIdMap;
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
            catch (ParseException pe) {
                throw new BdfStorageException(pe);
            }
        }
    }
}

