/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.jsonproducers.admin;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.json.SubsetTreeJson;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.json.FichothequeJson;
import java.io.IOException;
import java.util.Set;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;

public class FichothequeArrayJsonProperty
implements JsonProperty {
    private final Multi multi;
    private final MessageLocalisation messageLocalisation;
    private final Lang lang;

    public FichothequeArrayJsonProperty(Multi multi, MessageLocalisation messageLocalisation, Lang lang) {
        this.multi = multi;
        this.messageLocalisation = messageLocalisation;
        this.lang = lang;
    }

    @Override
    public String getName() {
        return "fichothequeArray";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        Set<String> set = this.multi.getExistingNameSet();
        jw.array();
        for (String name : set) {
            String state = this.multi.getState(name);
            BdfServer bdfServer = this.multi.getInitBdfServer(name);
            jw.object();
            jw.key("name").value(name);
            jw.key("state").value(state);
            jw.key("init").value(state.equals("active"));
            if (bdfServer != null) {
                this.fichothequeProperties(jw, bdfServer);
            } else {
                FichothequeJson.phrasesProperties(jw, this.multi.getBdfServerDirs(name), this.lang);
            }
            jw.endObject();
        }
        jw.endArray();
    }

    private void fichothequeProperties(JSONWriter jw, BdfServer bdfServer) throws IOException {
        FichothequeJson.phrasesProperties(jw, bdfServer, this.lang);
        SubsetTreeJson.Parameters parameters = new SubsetTreeJson.Parameters(bdfServer, this.lang, this.messageLocalisation);
        SubsetTreeJson.properties(jw, parameters, (short)1);
        SubsetTreeJson.properties(jw, parameters, (short)2);
        SubsetTreeJson.properties(jw, parameters, (short)3);
        SubsetTreeJson.properties(jw, parameters, (short)5);
        SubsetTreeJson.properties(jw, parameters, (short)4);
    }
}

