/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.multi.tools.PresenceInfo;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.List;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.security.PasswordChecker;

public class CentralPasswordChangeCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "CentralPasswordChange";
    public static final String PASSWORD1_PARAMNAME = "password1";
    public static final String PASSWORD2_PARAMNAME = "password2";

    public CentralPasswordChangeCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        boolean done;
        this.initCentralSphere();
        this.initCentralUser();
        String password = this.getPassword();
        String encryptedPassword = PasswordChecker.getHash("pbkdf2", password);
        this.initCentralEditors();
        CentralSphere centralSphere = this.getCentralSphere();
        synchronized (centralSphere) {
            done = this.getCentralUserEditor().setEncryptedPassword(encryptedPassword);
            this.saveChanges();
        }
        if (done) {
            List<PresenceInfo> presenceInfoList = PresenceInfo.scan(this.multi, this.centralUser, false);
            for (PresenceInfo presenceInfo : presenceInfoList) {
                BdfServer currentBdfServer;
                Redacteur redacteur = presenceInfo.getRedacteur();
                if (redacteur == null) continue;
                BdfServer bdfServer = currentBdfServer = presenceInfo.getBdfServer();
                synchronized (bdfServer) {
                    currentBdfServer.getPasswordManager().setEncryptedPassword(redacteur.getGlobalId(), encryptedPassword);
                }
            }
        }
        if (done) {
            return this.done("_ done.sphere.passwordchange");
        }
        return null;
    }

    private String getPassword() throws ErrorMessageException {
        String mdp2;
        String mdp1 = this.getMandatory(PASSWORD1_PARAMNAME);
        if (!mdp1.equals(mdp2 = this.getMandatory(PASSWORD2_PARAMNAME))) {
            throw BdfErrors.error("_ error.wrong.password_different");
        }
        String password = mdp1;
        if (password.length() == 0) {
            throw BdfErrors.error("_ error.empty.password");
        }
        if (password.length() < 4) {
            throw BdfErrors.error("_ error.wrong.password_tooshort");
        }
        return password;
    }
}

