/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands;

import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.MultiEditor;
import fr.exemole.bdfserver.multi.api.MultiMetadata;
import fr.exemole.bdfserver.multi.api.MultiMetadataEditor;
import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import fr.exemole.bdfserver.multi.commands.CreationParameters;
import fr.exemole.bdfserver.multi.commands.fichotheque.FichothequeCreationCommand;
import fr.exemole.bdfserver.storage.directory.bdfdata.StartValues;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.EditOrigin;
import net.fichotheque.utils.EditOriginUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.security.PasswordChecker;
import net.mapeadores.util.text.StringUtils;

public class IniCommand
extends AbstractMultiCommand {
    public static final String COMMAND_NAME = "Ini";
    public static final String LOGIN_PARAMNAME = "login";
    public static final String PASSWORD1_PARAMNAME = "password_1";
    public static final String PASSWORD2_PARAMNAME = "password_2";
    public static final String LANG_PARAMNAME = "lang";
    public static final String AUTHORITY_PARAMNAME = "authority";
    public static final String CREATEFICHOTHEQUE_PARAMNAME = "createfichotheque";

    public IniCommand(RequestMap requestMap, Multi multi) {
        super(multi, requestMap);
    }

    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        Result result = this.doIniCommand();
        return result.getCommandMessage();
    }

    public Result doIniCommand() {
        EditOrigin editOrigin = EditOriginUtils.newEditOrigin("multi-admin/init");
        ArrayList<String> iniLineList = new ArrayList<String>();
        MultiEditor multiEditor = this.multi.getMultiEditor(editOrigin);
        Result result = new Result();
        try {
            this.checkLineList(result, iniLineList, multiEditor.getMultiMetadataEditor());
            CreationParameters creationParameters = this.checkCreationParameters(result, this.multi.getMultiMetadata());
            this.writeIniFile(iniLineList);
            this.multi.getMultiConf().update();
            if (creationParameters != null) {
                this.multi.createFichotheque(creationParameters);
            }
            multiEditor.saveChanges();
            result.setCommandMessage(LogUtils.done("_ done.multi.ini", new Object[0]));
        }
        catch (ErrorMessageException eme) {
            result.setCommandMessage(eme.getErrorMessage());
        }
        return result;
    }

    private void checkLineList(Result result, List<String> iniLineList, MultiMetadataEditor multiMetadataEditor) throws ErrorMessageException {
        String authority = this.getMandatory(AUTHORITY_PARAMNAME);
        Lang lang = this.getLang();
        String login = this.getMandatory(LOGIN_PARAMNAME);
        String password1 = this.getMandatory(PASSWORD1_PARAMNAME);
        String password2 = this.getMandatory(PASSWORD2_PARAMNAME);
        if (!StringUtils.isAuthority(authority)) {
            throw new ErrorMessageException("_ error.wrong.authority", authority);
        }
        if (!SphereUtils.testLogin(login)) {
            throw new ErrorMessageException("_ error.wrong.login", login);
        }
        if (!password1.equals(password2)) {
            throw new ErrorMessageException("_ error.wrong.password_different");
        }
        result.setIni(login);
        this.addLine(iniLineList, LOGIN_PARAMNAME, login);
        this.addLine(iniLineList, "password", PasswordChecker.getHash("pbkdf2", password1));
        multiMetadataEditor.setAuthority(authority);
        multiMetadataEditor.setWorkingLangs(LangsUtils.wrap(lang));
    }

    private CreationParameters checkCreationParameters(Result result, MultiMetadata multiMetadata) throws ErrorMessageException {
        if (!this.multi.isEmpty()) {
            return null;
        }
        if (!this.requestMap.isTrue(CREATEFICHOTHEQUE_PARAMNAME)) {
            return null;
        }
        String fichothequeName = this.getFichothequeName("newfichotheque");
        StartValues startValues = FichothequeCreationCommand.getStartValues(this.requestMap).authority(multiMetadata.getAuthority()).basename(fichothequeName).workingLangs(multiMetadata.getWorkingLangs());
        result.setCreation(fichothequeName, startValues);
        return CreationParameters.initNew(fichothequeName, startValues);
    }

    private void addLine(List<String> lineList, String name, String value) {
        lineList.add(name + "=" + value);
    }

    private Lang getLang() throws ErrorMessageException {
        String langValue = this.getMandatory(LANG_PARAMNAME);
        try {
            return Lang.parse(langValue);
        }
        catch (ParseException pe) {
            throw new ErrorMessageException("_ error.wrong.lang", langValue);
        }
    }

    private void writeIniFile(List<String> lineList) throws ErrorMessageException {
        try {
            FileUtils.writeLines(this.multi.getMultiConf().getInitFile(), "UTF-8", lineList);
        }
        catch (IOException ioe) {
            throw new ErrorMessageException("_ error.exception.io", ioe.getLocalizedMessage());
        }
    }

    public static class Result {
        private CommandMessage commandMessage;
        private String adminLogin;
        private String newFichothequeName;
        private StartValues startValues;

        private Result() {
        }

        public boolean hasError() {
            return this.commandMessage.isErrorMessage();
        }

        public CommandMessage getCommandMessage() {
            return this.commandMessage;
        }

        public boolean isWithNewFichotheque() {
            return this.newFichothequeName != null;
        }

        public String getNewFichothequeName() {
            return this.newFichothequeName;
        }

        public String getAdminLogin() {
            return this.adminLogin;
        }

        public StartValues getStartValues() {
            return this.startValues;
        }

        private void setIni(String adminLogin) {
            this.adminLogin = adminLogin;
        }

        private void setCreation(String newFichothequeName, StartValues startValues) {
            this.newFichothequeName = newFichothequeName;
            this.startValues = startValues;
        }

        private void setCommandMessage(CommandMessage commandMessage) {
            this.commandMessage = commandMessage;
        }
    }
}

